<!--
 // WEBSITE: https://themefisher.com
 // TWITTER: https://twitter.com/themefisher
 // FACEBOOK: https://www.facebook.com/themefisher
 // GITHUB: https://github.com/themefisher/
-->

<!-- 
THEME: Constra - Construction Html5 Template
VERSION: 1.0.0
AUTHOR: Themefisher

HOMEPAGE: https://themefisher.com/products/constra-construction-template/
DEMO: https://demo.themefisher.com/constra/
GITHUB: https://github.com/themefisher/Constra-Bootstrap-Construction-Template

WEBSITE: https://themefisher.com
TWITTER: https://twitter.com/themefisher
FACEBOOK: https://www.facebook.com/themefisher
-->

<!DOCTYPE html>
<html data-base-url="<?php echo e(url('/')); ?>" lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>

  <!-- Basic Page Needs
================================================== -->
  <meta charset="utf-8">
  <title>Atulya Scaffolding Safety and Services LLP</title>

  <!-- Mobile Specific Metas
================================================== -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="description" content="Construction Html5 Template">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
  <meta name=author content="Themefisher">
  <meta name=generator content="Themefisher Constra HTML Template v1.0">

  <!-- Favicon
================================================== -->
  <link rel="icon" type="image/png" href="<?php echo e(asset('public/front/images/favicon.png')); ?>">

  <!-- CSS
================================================== -->
  <!-- Bootstrap -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/bootstrap/bootstrap.min.css')); ?>">
  <!-- FontAwesome -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/fontawesome/css/all.min.css')); ?>">
  <!-- Animation -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/animate-css/animate.css')); ?>">
  <!-- slick Carousel -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/slick/slick.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/slick/slick-theme.css')); ?>">
  <!-- Colorbox -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/colorbox/colorbox.css')); ?>">
  <!-- Template styles-->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/css/style.css')); ?>">

  
  
    <!-- initialize jQuery Library -->
  <script src="<?php echo e(asset('public/front/plugins/jQuery/jquery.min.js')); ?>"></script>

  <!--
*
 *
 *
 * MY created scripts are included below
 *
 *
 *
 *
 *
-->

<script src="<?php echo e(asset('public/js/config_file.js')); ?>"></script>
<script src="<?php echo e(asset('public/tools/Parsley.js-2.9.2/dist/parsley.js')); ?>"></script>
<script src="<?php echo e(asset('public/tools/Parsley.js-2.9.2/dist/parsley-custom-validators.js')); ?>"></script>
<script src="<?php echo e(asset('public/js/ajax_form_submit.js')); ?>"></script>

  <link rel="stylesheet" href="<?php echo e(asset('public/css/my_cms.css')); ?>">


<script>

</script>



  <!-- Flash Messages -->
  <!-- <link rel="stylesheet" href="<?php echo e(asset('public/css/flash_messages.css')); ?>"> -->
  <link rel="stylesheet" href="<?php echo e(asset('public/css/flash_messages_new.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('public/tools/Parsley.js-2.9.2/dist/parsley.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('public/css/my_grid.css')); ?>">
  <script src="<?php echo e(asset('public/js/my_ajax_grid.js')); ?>"></script>
  

<script src="<?php echo e(asset('public/js/custom_scripts.js')); ?>"></script>
<script src="<?php echo e(asset('public/js/my_scripts.js')); ?>"></script>

  


  
</head>
<body>
  <div class="body-inner">
    
<?php $__env->startSection('topbar'); ?>
 
 <?php echo $__env->make('front.layouts.topbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>

<?php $__env->startSection('header'); ?>
 
 <?php echo $__env->make('front.layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>



  <!-- Content Wrapper. Contains page content -->    
      
  <?php $__env->startSection('main_content'); ?>
  
  

<div id="banner-area" class="banner-area" style="background-image:url(<?php echo e(asset('public/front/images/banner/banner1.jpg')); ?>)">
  <div class="banner-text">
    <div class="container">
        <div class="row">
          <div class="col-lg-12">
              <div class="banner-heading">
                <h1 class="banner-title">Contact</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                      <li class="breadcrumb-item"><a href="#">Home</a></li>
                      <li class="breadcrumb-item"><a href="#">Company</a></li>
                      <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
                    </ol>
                </nav>
              </div>
          </div><!-- Col end -->
        </div><!-- Row end -->
    </div><!-- Container end -->
  </div><!-- Banner text end -->
</div><!-- Banner area end --> 

<section id="main-container" class="main-container">
 <div class="container">
     
     
    <div class="row text-center">
      <div class="col-12">
        <h2 class="section-title">Reaching our Office</h2>
        <h3 class="section-sub-title">Find Our Location</h3>
      </div>
    </div>
    <!--/ Title row end -->

    <div class="row">
      <div class="col-md-4">
        <div class="ts-service-box-bg text-center h-100">
          <span class="ts-service-icon icon-round">
            <i class="fas fa-map-marker-alt mr-0"></i>
          </span>
          <div class="ts-service-box-content">
            <h4>Visit Our Office</h4>
            <p>Bharthipur, Kakwa Road, Amethi (U.P.), India</p>
          </div>
        </div>
      </div><!-- Col 1 end -->

      <div class="col-md-4">
        <div class="ts-service-box-bg text-center h-100">
          <span class="ts-service-icon icon-round">
            <i class="fa fa-envelope mr-0"></i>
          </span>
          <div class="ts-service-box-content">
            <h4>Email Us</h4>
            <p>atulyascaffoldinservice01@gmail.com</p>
          </div>
        </div>
      </div><!-- Col 2 end -->

      <div class="col-md-4">
        <div class="ts-service-box-bg text-center h-100">
          <span class="ts-service-icon icon-round">
            <i class="fa fa-phone-square mr-0"></i>
          </span>
          <div class="ts-service-box-content">
            <h4>Call Us</h4>
            <p>(+91) 880-217-022</p>
          </div>
        </div>
      </div><!-- Col 3 end -->

    </div><!-- 1st row end -->

    <div class="gap-60"></div>

    <!-- <div class="google-map">
      <div id="map" class="map" data-latitude="40.712776" data-longitude="-74.005974" data-marker="images/marker.png" data-marker-name="Constra"></div>
    </div> -->

    <div class="gap-40"></div>

    <div class="row">
      <div class="col-md-12">
        <h3 class="column-title">We love to hear</h3>
        <!-- contact form works with formspree.io  -->
        <!-- contact form activation doc: https://docs.themefisher.com/constra/contact-form/ -->
        
         <div style="text-align: center; padding-left: 20px; padding-right: 20px;padding-top:2px;">
            <?php echo $__env->make('common.templates.flash_message_all', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div> 
          
     
         <?php echo $__env->make('common.templates.ajax_div', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>  
        
        
        <div class="error-container"></div>
        <form class="ajax-form-submit" id="contact-form" action="<?php echo e(url('contact_us')); ?>" method="post" role="form" data-hide-on-complete="false">
            
            <?php echo e(method_field('POST')); ?>

            <?php echo e(csrf_field()); ?>

 
                     

          
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label>Name</label>
                <input class="form-control form-control-name" name="name" id="name" placeholder="" type="text" required data-parsley-required="true" data-parsley-pattern="^[a-zA-Z ]+$" data-parsley-pattern-message="Name Must be alphabets only" data-parsley-minlength='2'  data-parsley-maxlength='100' >
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label>Email</label>
                <input class="form-control form-control-email" name="email" id="email" placeholder="" type="email"
                  required data-parsley-required="true" data-parsley-type="email" data-parsley-minlength='2'  data-parsley-maxlength='100'>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label>Subject</label>
                <input class="form-control form-control-subject" name="subject" id="subject" placeholder="" required data-parsley-required="true" data-parsley-minlength='5'  data-parsley-maxlength='100'>
              </div>
            </div>
          </div>
          <div class="form-group">
            <label>Message</label>
            <textarea class="form-control form-control-message" name="message" id="message" placeholder="Message" rows="10"
              required data-parsley-required="true" data-parsley-minlength='5'  data-parsley-maxlength='255'></textarea>
          </div>
          <div class="text-right"><br>
            <button class="btn btn-primary solid blank" type="submit">Send Message</button>
          </div>
        </form>
        
         <script>$("#contact-form").parsley();</script>
      </div>

    </div><!-- Content row -->
  </div><!-- Conatiner end -->
</section><!-- Main container end -->



  <?php echo $__env->yieldSection(); ?> 
 

    
 
     
<?php $__env->startSection('footer'); ?>
 
 <?php echo $__env->make('front.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>
 



    
    <!-- Javascript Files
  ================================================== -->


  <!-- Bootstrap jQuery -->
  <script src="<?php echo e(asset('public/front/plugins/bootstrap/bootstrap.min.js')); ?>" defer></script>
  <!-- Slick Carousel -->
  <script src="<?php echo e(asset('public/front/plugins/slick/slick.min.js')); ?>"></script>
  <script src="<?php echo e(asset('public/front/plugins/slick/slick-animation.min.js')); ?>"></script>
  <!-- Color box -->
  <script src="<?php echo e(asset('public/front/plugins/colorbox/jquery.colorbox.js')); ?>"></script>
  <!-- shuffle -->
  <script src="<?php echo e(asset('public/front/plugins/shuffle/shuffle.min.js')); ?>" defer></script>


  <!-- Google Map API Key-->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCcABaamniA6OL5YvYSpB3pFMNrXwXnLwU" defer></script>
  <!-- Google Map Plugin-->
  <script src="<?php echo e(asset('public/front/plugins/google-map/map.js')); ?>" defer></script>

  <!-- Template custom -->
  <script src="<?php echo e(asset('public/front/js/script.js')); ?>"></script>

  </div><!-- Body inner end -->
  </body>

  </html><?php /**PATH /home/u967478337/domains/evsgroup.in/public_html/atulya/atulya/resources/views/front/contact_us.blade.php ENDPATH**/ ?>