<?php

use App\Http\Controllers\employee\AssignmentCategoryController;
use App\Http\Controllers\employee\DashboardController as EmployeeDashboardController;
use App\Http\Controllers\employee\auth\LoginController as EmployeeLoginController;




use App\Http\Controllers\LoginController;
use App\Http\Controllers\employee\AssignmentController;
use App\Http\Controllers\employee\EmployeeController;
use Illuminate\Support\Facades\Route;



//Route::group(['prefix'=>'employee'],function(){
 // Route::group(['name'=>'employee.','prefix'=>'employee'],function(){
Route::name('employee.')->prefix('employee')->group(function(){
    // Guest middle URL can be accessed without login
    Route::group(['middleware'=>'employee.guest'],function(){
        Route::get('login',[EmployeeLoginController::class,'index'])->name('login');
    Route::post('authenticate',[EmployeeLoginController::class,'authenticate'])->name('authenticate');
    });
  // Guest middle URL can be accessed without login
      Route::group(['middleware'=>'employee.auth'],function(){
        
        

       Route::get('dashboard',[EmployeeDashboardController::class,'index'])->name('dashboard');
     Route::get('logout',[EmployeeLoginController::class,'logout'])->name('logout');



 /*
     * Dummy
     */
     Route::any('dummy/dummy_grid', '\App\Http\Controllers\employee\DummyController@dummy_grid');
    Route::resource('dummy', '\App\Http\Controllers\employee\DummyController');
    
    
     /*
     * Student Attendance
     */
     Route::any('student_attendance/student_attendance_grid', '\App\Http\Controllers\employee\StudentAttendanceController@student_attendance_grid');
     Route::any('student_attendance/get_students_by_standard_section', '\App\Http\Controllers\employee\StudentAttendanceController@get_students_by_standard_section');
    Route::resource('student_attendance', '\App\Http\Controllers\employee\StudentAttendanceController');
    
    
            /*
     * Import Export
     */
    Route::any('import_export/result_page', '\App\Http\Controllers\employee\ImportExportController@result_page');
    
      Route::get('import_export/import_student_step_3', function() { return redirect("employee/import_export/import_student_step_1"); });
        Route::post('import_export/import_student_step_3', '\App\Http\Controllers\employee\ImportExportController@import_student_step_3');
        
         Route::get('import_export/import_student_step_2', function() { return redirect("employee/import_export/import_student_step_1"); });
       Route::post('import_export/import_student_step_2', '\App\Http\Controllers\employee\ImportExportController@import_student_step_2');
       
       Route::get('import_export/import_student_step_1', '\App\Http\Controllers\employee\ImportExportController@import_student_step_1');
     
       Route::get('import_export/import_student_get_format', '\App\Http\Controllers\employee\ImportExportController@get_format');
       
    Route::resource('import_export', '\App\Http\Controllers\employee\ImportExportController');
    
    
            /*
     * Student
     */
     Route::any('student/student_ajax_fetch_cities_by_state', '\App\Http\Controllers\employee\StudentController@student_ajax_fetch_cities_by_state');
     Route::any('student/parent_ajax_fetch_cities_by_state', '\App\Http\Controllers\employee\StudentController@parent_ajax_fetch_cities_by_state');
     Route::any('student/student_grid', '\App\Http\Controllers\employee\StudentController@student_grid');
    Route::resource('student', '\App\Http\Controllers\employee\StudentController');
    
    
           /*
     * Fees
     */
    
    Route::any('fees/fee_collection/fee_content_by_standard_interval', '\App\Http\Controllers\employee\fees\FeeCollectionController@fee_content_by_standard_interval');
    Route::any('fees/fee_collection/fee_search_student_grid', '\App\Http\Controllers\employee\fees\FeeCollectionController@fee_search_student_grid');
    Route::any('fees/fee_collection/fee_collection_grid', '\App\Http\Controllers\employee\fees\FeeCollectionController@fee_collection_grid');
    Route::resource('fees/fee_collection', '\App\Http\Controllers\employee\fees\FeeCollectionController');
    
    Route::any('fees/fee_standard_amount/fee_standard_grid', '\App\Http\Controllers\employee\fees\FeeStandardAmountController@fee_standard_grid');
    Route::resource('fees/fee_standard_amount', '\App\Http\Controllers\employee\fees\FeeStandardAmountController');
    
    Route::any('fees/fee_interval/fee_interval_grid', '\App\Http\Controllers\employee\fees\FeeIntervalController@fee_interval_grid');
    Route::resource('fees/fee_interval', '\App\Http\Controllers\employee\fees\FeeIntervalController');
    
    Route::any('fees/fee_type/fee_type_grid', '\App\Http\Controllers\employee\fees\FeeTypeController@fee_type_grid');
    Route::resource('fees/fee_type', '\App\Http\Controllers\employee\fees\FeeTypeController');
    
           /*
     * Examinations
     */
    
     Route::any('examination/exam/examination_grid', '\App\Http\Controllers\employee\examination\ExaminationController@examination_grid');
    Route::resource('examination/exam', '\App\Http\Controllers\employee\examination\ExaminationController');
    
    
     Route::any('examination/examination_sub_type/examination_sub_type_grid', '\App\Http\Controllers\employee\examination\ExaminationSubTypeController@examination_sub_type_grid');
    Route::resource('examination/examination_sub_type', '\App\Http\Controllers\employee\examination\ExaminationSubTypeController');
    
    
     Route::any('examination/examination_type/examination_type_grid', '\App\Http\Controllers\employee\examination\ExaminationTypeController@examination_type_grid');
    Route::resource('examination/examination_type', '\App\Http\Controllers\employee\examination\ExaminationTypeController');
    
    
    
     Route::any('examination/examination_category/examination_category_grid', '\App\Http\Controllers\employee\examination\ExaminationCategoryController@examination_category_grid');
    Route::resource('examination/examination_category', '\App\Http\Controllers\employee\examination\ExaminationCategoryController');
    
    
    
           /*
     * Assignments
     */
      
    Route::any('assignment/assignment_by_standard_section_grid/{standard_id}/{section_id}', '\App\Http\Controllers\employee\AssignmentController@assignment_by_standard_section_grid')
            ->where('standard_id', '.+')
            ->where('section_id', '.+');
    
    Route::any('assignment/assignment_by_section/{standard_id}/{section_id}', '\App\Http\Controllers\employee\AssignmentController@assignment_by_section')
            ->where('standard_id', '.+')
            ->where('section_id', '.+');
    
    Route::any('assignment/standard_by_school_grid', [AssignmentController::class,'standard_by_school_grid']);   
    Route::resource('assignment', AssignmentController::class)   ;
    
    
    
    
    Route::any('assignment_category/assignment_category_grid', '\App\Http\Controllers\employee\AssignmentCategoryController@assignment_category_grid');   
   // Route::resource('assignment_category', '\App\Http\Controllers\employee\AssignmentCategoryController')   ;
    Route::resource('assignment_category', AssignmentCategoryController::class)   ;
    
    
           /*
     * Timetable
     */
    
    Route::any('timetable/standard_subject_dropdown_options', '\App\Http\Controllers\employee\TimetableController@standard_subject_dropdown_options');
    Route::any('timetable/standard_by_school_grid', '\App\Http\Controllers\employee\TimetableController@standard_by_school_grid');   
    Route::resource('timetable', '\App\Http\Controllers\employee\TimetableController')   ;
    
           /*
     * Employee
     */
    Route::any('employee/employee_grid', '\App\Http\Controllers\employee\EmployeeController@employee_grid');
    Route::any('employee/profile', '\App\Http\Controllers\employee\EmployeeController@profile')->where('id', '.+');
    Route::any('employee/reset_password_to_default/{id}', '\App\Http\Controllers\employee\EmployeeController@reset_password_to_default')->where('id', '.+');
    Route::get('employee/change_password', '\App\Http\Controllers\employee\EmployeeController@change_password');
    Route::post('employee/change_password', '\App\Http\Controllers\employee\EmployeeController@change_password_submit');

    Route::any('employee/employee_role_grid', '\App\Http\Controllers\employee\EmployeeController@employee_role_grid');
    Route::any('employee/sync_employee_role', '\App\Http\Controllers\employee\EmployeeController@sync_employee_role');


  //  Route::resource('/employee/employee', '\App\Http\Controllers\employee\EmployeeController');
 Route::resource('employee', EmployeeController::class);
    
    /*
     * Subjects
     */
  
//    Route::any('employee/standard_subject/standard_subject_grid', '\App\Http\Controllers\employee\StandardSubjectController@standard_subject_grid');
//    Route::any('employee/standard_subject/standard_by_school/{school_id}', '\App\Http\Controllers\employee\StandardSubjectController@standard_by_school')->where('school_id', '.+');
//    Route::any('employee/standard_subject/edit_by_school/{school_id}/{standard_id}', '\App\Http\Controllers\employee\StandardSubjectController@edit_by_school')->where('school_id', '.+')->where('standard_id', '.+');
    Route::any('standard_subject/standard_by_school_grid', '\App\Http\Controllers\employee\StandardSubjectController@standard_by_school_grid');   
    Route::resource('standard_subject', '\App\Http\Controllers\employee\StandardSubjectController')   ;
    
     /*
     * Subjects
     */
    
    Route::any('subject/subject_grid', '\App\Http\Controllers\employee\SubjectController@subject_grid');   
    Route::resource('subject', '\App\Http\Controllers\employee\SubjectController');
    
    
     /*
     * Sections
     */
    
    Route::any('section/section_grid', '\App\Http\Controllers\employee\SectionController@section_grid');   
    Route::resource('section', '\App\Http\Controllers\employee\SectionController')   ;
    
      /*
     * Classes or Standards
     */
    
    Route::any('standard/standard_grid', '\App\Http\Controllers\employee\StandardController@standard_grid');   
    Route::resource('standard', '\App\Http\Controllers\employee\StandardController')   ;
    
     /*
     * Batch
     */
    
    Route::any('batch/batch_grid', '\App\Http\Controllers\employee\BatchController@batch_grid');   
    Route::resource('batch', '\App\Http\Controllers\employee\BatchController')   ;
    
    
         /*
         * Role
         */
        Route::any('rbac/role/role_grid', '\App\Http\Controllers\employee\rbac\RoleController@role_grid');
        Route::resource('rbac/role', '\App\Http\Controllers\employee\rbac\RoleController');
        
        /*
         * Permission
         */
        Route::any('rbac/permission/permission_grid', '\App\Http\Controllers\employee\rbac\PermissionController@permission_grid');
        Route::resource('rbac/permission', '\App\Http\Controllers\employee\rbac\PermissionController');

        /*
         * Module Role Permission
         */
        Route::any('rbac/module_role_permission/manage_permission_grid', '\App\Http\Controllers\employee\rbac\ModuleRolePermissionController@manage_permission_grid');

        Route::any('rbac/module_role_permission/sync_module_role_permission', '\App\Http\Controllers\employee\rbac\ModuleRolePermissionController@sync_module_role_permission');
        Route::resource('rbac/module_role_permission', '\App\Http\Controllers\employee\rbac\ModuleRolePermissionController');
        
        
    
    
    
/*
     * SiteSettings
     */
    Route::any('site_setting/site_setting_grid', '\App\Http\Controllers\employee\SiteSettingController@site_setting_grid');
    Route::resource('site_setting', '\App\Http\Controllers\employee\SiteSettingController');

/*
     * Dashboard
     */
//     Route::any('dashboard/set_school_id/{school_id}', '\App\Http\Controllers\employee\DashboardController@set_school_id')->where('school_id', '.+');
//     Route::any('dashboard/select_school', '\App\Http\Controllers\employee\DashboardController@select_school');
     //Route::any('dashboard', '\App\Http\Controllers\employee\DashboardController@index');
    











 
    });

});