



@extends('owner.layouts.layout')

@section('main_content')

@include('common.templates.content_header',['module'=>'Training Certificate','breadcrumb'=>'Training Certificate','breadcrumb_active'=>'Edit'])

<!--begin::App Content-->
<div class="app-content"> <!--begin::Container-->
    <div class="container-fluid"> <!--begin::Row-->
        <div class="row">
            <div class="col-12"> 
                <!-- Default box -->
                <div class="card card-primary card-outline p-0">
                    <div class="card-header">
                        <!--                                    <h3 class="card-title">Title</h3>-->

                        @include('common.templates.back_button')

                        <div class="card-tools">
                          @include('common.templates.add_new_button',['url'=>'owner/training_certificate/create'])

                        </div>
                    </div>

                    <div class="card-body table-responsive">

    <!-- form start -->
        <form class="ajax-form-submit" id="my_form" name="my_form" method="post" action="{{ route('owner.training_certificate.update', $row->id) }}" data-redirect-link="{{url('owner/training_certificate')}}" enctype='multipart/form-data' onsubmit="tinyMCE.triggerSave();">
             {{ method_field('PATCH') }}
                {{ csrf_field() }}

      


                        <div class="row">

                            <div class="col-md-12 col-12">



                                

                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Name</label>
                                    <input type="text" name='name' id="name" class="form-control"  placeholder="Name" data-parsley-required='true' data-parsley-minlength='2'  data-parsley-maxlength='100' value="{{$row->name}}" >
                                </div>
                                <!-- /.form-group -->            

                                   <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Email</label>
                                    <input type="text" name='email' id="email" class="form-control"  placeholder="Email" data-parsley-required='true' data-parsley-minlength='2'  data-parsley-maxlength='100' data-parsley-type="email" value="{{$row->email}}">
                                </div>
                                <!-- /.form-group -->            

                             
                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Mobile</label>
                                    <input type="text" name='mobile' id="mobile" class="form-control"  placeholder="Mobile" data-parsley-required='true' data-parsley-minlength='10'  data-parsley-maxlength='10' data-parsley-type="digits" value="{{$row->mobile}}">
                                </div>
                                <!-- /.form-group -->            

                             
                                
                                
                                     <div class="form-group mb-3">
                                        <label class="form-label fw-bold" for="file">File</label>
                                        <div class="input-group mb-3">
                                            <input name="file" type="file" id="file" class="form-control" data-parsley-fileextension="pdf" data-parsley-fileextension-message="File should be .pdf only" data-parsley-maxfilesize="5120" data-parsley-maxfilesize-message="The file must be samller than 5MB" data-title="Training Certificate" title="Training Certificate"> 
                                            <label class="input-group-text" for="file">(.pdf)</label> </div>
                                    </div>

                                    <!-- /.form-group -->

                                 <div class="form-group mb-3">
                                     <label class="form-label fw-bold">Current Doc</label>
                                    <div style="border:0px">
                                          @php 
            $ext = strtolower($row->extension);
                if($ext == 'pdf'){
                    $icon_class = 'bi bi-file-pdf';
                }elseif($ext == 'xlsx'  || $ext == 'xls'){
                 $icon_class = 'bi bi-filetype-xlsx';                
                }elseif($ext == 'docx'  || $ext == 'doc'){
                 $icon_class = 'bi bi-filetype-docx';
                }else{
                $icon_class = 'bi bi-download';
                }
            @endphp
                                         <a href="{{url('owner/training_certificate/download/'.$row->path)}}" class="btn btn-sm btn-danger" target="_blank"><i class="{{$icon_class}}"></i> Download</a>
                                   
                                    </div>
                                
                                </div>
                                <!-- /.form-group -->

                              
                                
<!--                                
                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Status</label>
                                    <select name="status" id="status" class="form-control form-select" data-parsley-required='true'>
                                        <option value="">Select</option>            
                                        @foreach(config('constants.GENERAL_STATUS') as $key=>$status)
                                        <option value='{{$key}}' @if($key == $row->status) selected @endif>{{$status}}</option>
                                        @endforeach
                                    </select>
                                </div>-->
                                <!-- /.form-group -->


                         

                            </div>
                            <!-- /.col-md-12 col-12 -->


                        </div>
                        <!-- /.row -->
     
          
            
                          <div class="row mt-4 mb-4">
                                <div class="col-md-12 col-12">
                                    <div class="box-footer float-end">                
                                        <button type="submit" class="btn btn-primary pull-right"><i class="fas fa-save"></i> Save</button>
                                    </div>
                                    <!-- /.box-footer -->
                                </div>
                                <!-- /.col-md-12 col-12 -->
                            </div>
                            <!-- /.row -->

             
        </form>
        <script>$("#my_form").parsley();</script>



                    </div> 
                    <!-- /.card-body -->
<!--                    <div class="card-footer">Footer</div> -->
                    <!-- /.card-footer-->
                </div> 
                <!-- /.card -->
            </div>
        </div> 
        <!--end::Row-->
    </div>
</div>
<!--end::App Content-->




@endsection



