

@extends('owner.layouts.layout')

@section('main_content')

@include('owner.templates.content_header',['module'=>'Employees','breadcrumb'=>'Employee','breadcrumb_active'=>'Edit'])



<!-- Main content -->
<section class="content">

    <!-- /.row -->
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-info no-padding">
                <div class="box-header with-border">
                    <button type="button" class="btn btn-success pull-left" style="margin-right: 5px;"onclick="history.back(-1)" >
                        <i class="fa fa-reply"></i><a href="#" style="color:#FFFFFF"> Back</a>

                    </button>
                    <a href="{{url('owner/rbac/module/create')}}" class="btn btn-primary "><i class="fa fa-plus"></i> Add New</a>

                </div>
                <!-- /.box-header -->
                <div class="box-body">

<!-- form start -->
        <form class="ajax-form-submit" id="my_form" name="my_form" method="post" action="{{ route('site_setting.update', $row->id) }}" data-redirect-link="{{url('owner/site_setting')}}">
             {{ method_field('PATCH') }}
                {{ csrf_field() }}




                <div class="row">

                    <div class="col-md-6 col-6">

                        <div class="form-group">
                            <label>Site Name</label>
                            <input type="text" name='name' id="name" class="form-control" placeholder="Name" data-parsley-required='true' data-parsley-minlength='2'  data-parsley-maxlength='100' value="{{$row->site_name}}">
                        </div>
                        <!-- /.form-group -->     
                        
                        <div class="form-group">
                            <label>Site URL</label>
                            <input type="text" name='url' id="url" class="form-control" placeholder="URL" data-parsley-minlength='2'  value="{{$row->site_url}}">
                        </div>
                        <!-- /.form-group -->            

                        
                        <div class="form-group">
                            <label>Site Key</label>
                            <input type="text" name='key' id="key" class="form-control" placeholder="Key" data-parsley-minlength='2'  value="{{$row->site_key}}">
                        </div>
                        <!-- /.form-group -->            

                        
                        
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Email"  data-parsley-type='email' data-parsley-maxlength='100'  data-parsley-minlength='7' value="{{$row->site_default_email}}">
                        </div>
                        <!-- /.form-group -->          



                    </div>



                    <div class="col-md-6 col-6">


                        
                        

                        <div class="form-group">
                            <label>Layout</label>
                            <select name="site_layout" class="form-control" data-parsley-required="true">
                                <option value="">Select Layout</option>
                                @if(!empty(config('site_setting.SITE_LAYOUT')))
                                    @foreach(config('site_setting.SITE_LAYOUT') as $layout)
                                        
                                    <option value="{{$layout['class']}}" @if($row->site_layout_class == $layout['class']) selected @endif>{{$layout['name']}}</option>
                                    
                                    @endforeach
                                @endif
                                
                            </select>
                            
                        </div>
                        <!-- /.form-group -->   
                        
                        <div class="form-group">
                            <label>Skin</label>
                            <select name="site_skin" class="form-control" data-parsley-required="true">
                                <option value="">Select Skin</option>
                                @if(!empty(config('site_setting.SITE_SKIN')))
                                    @foreach(config('site_setting.SITE_SKIN') as $skin)
                                        
                                    <option value="{{$skin['class']}}" @if($row->site_skin_class == $skin['class']) selected @endif>{{$skin['name']}}</option>
                                    
                                    @endforeach
                                @endif
                                
                            </select>
                            
                        </div>
                        <!-- /.form-group -->   
                        
                        
                        
                        
                        <div class="form-group">
                            <label class="control-label">Contact</label>
                           <input type="tel" name='mobile' id="mobile" class="form-control" placeholder="Contact" data-parsley-required='true' data-parsley-type='digits' data-parsley-minlength='10' data-parsley-maxlength='10' value="{{$row->site_owner_contact}}">
                        </div>
                        <!-- /.form-group -->         

        



                    </div>
                    <!-- /.col-md-6 col-6 -->


                </div>
                <!-- /.row -->


                     <div class="row">
                <div class="col-md-12 col-12">
                    <div class="box-footer">                
                        <button type="submit" class="btn btn-primary pull-right">Save</button>
                    </div>
                    <!-- /.box-footer -->
                </div>
                 <!-- /.col-md-12 col-12 -->
            </div>
             <!-- /.row -->
             
        </form>
        <script>$("#my_form").parsley();</script>


                </div>
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
        </div>
    </div>

</section>
<!-- /.content -->




<script>

    $('#my_form').find('input, textarea, button, select').attr('disabled','disabled');
</script>


@endsection







