



@extends('owner.layouts.layout')

@section('main_content')

@include('common.templates.content_header',['module'=>'Projects','breadcrumb'=>'Project','breadcrumb_active'=>'Edit'])

<!--begin::App Content-->
<div class="app-content"> <!--begin::Container-->
    <div class="container-fluid"> <!--begin::Row-->
        <div class="row">
            <div class="col-12"> 
                <!-- Default box -->
                <div class="card card-primary card-outline p-0">
                    <div class="card-header">
                        <!--                                    <h3 class="card-title">Title</h3>-->

                        @include('common.templates.back_button')

                        <div class="card-tools">
                          @include('common.templates.add_new_button',['url'=>'owner/project/create'])

                        </div>
                    </div>

                    <div class="card-body table-responsive">

    <!-- form start -->
        <form class="ajax-form-submit" id="my_form" name="my_form" method="post" action="{{ route('owner.project.update', $row->id) }}" data-redirect-link="{{url('owner/project')}}" enctype='multipart/form-data' onsubmit="tinyMCE.triggerSave();">
             {{ method_field('PATCH') }}
                {{ csrf_field() }}

      


                        <div class="row">

                            <div class="col-md-12 col-12">



                                

                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Title</label>
                                    <input type="text" name='title' id="title" class="form-control"  placeholder="Title" data-parsley-required='true' data-parsley-pattern="^[a-zA-Z ]+$" data-parsley-pattern-message="Name Must be alphabets only" data-parsley-minlength='2'  data-parsley-maxlength='100' value="{{$row->title}}" >
                                </div>
                                <!-- /.form-group -->            

                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Category</label>
                                    <input type="text" name='category' id="category" class="form-control" placeholder="Category" data-parsley-required='true' data-parsley-pattern="^[a-zA-Z ]+$" data-parsley-pattern-message="Category Must be alphabets only" data-parsley-minlength='2'  data-parsley-maxlength='50' value="{{$row->category}}"  >
                                </div>
                                <!-- /.form-group -->            


                                
                                     <div class="form-group mb-3">
                                        <label class="form-label fw-bold" for="profile_image">Project Image</label>
                                        <div class="input-group mb-3">
                                            <input name="project_image" type="file" id="project_image" class="form-control" data-parsley-fileextension="jpg,jpeg" data-parsley-fileextension-message="File should be .jpg or .jpeg only" data-parsley-maxfilesize="2048" data-parsley-maxfilesize-message="The file must be samller than 2MB" data-title="Project Image" title="Project image"> 
                                            <label class="input-group-text" for="project_image">(.jpg,.jpeg)</label> </div>
                                    </div>

                                    <!-- /.form-group -->

                                 <div class="form-group mb-3">
                                     <label class="form-label fw-bold">Current Image</label>
                                    <div class="form-control" style="border:0px">
                                          <span class="start"><img src="{{create_image_path($row->image)}}" class="img elevation-2" alt="User Image" height='150' width="150"></span>
           
                                    </div>
                                
                                </div>
                                <!-- /.form-group -->

                              
     


                                  <div class="form-group mb-3">
                                    <label class="form-label fw-bold">Description</label>
                                    <textarea  name="description" id="description" class="form-control" title="Description" placeholder="Description" data-parsley-required="true" style='height: 124px;'>
                                        {{$row->description}}
                                    </textarea>

                                </div>
                                <!-- /.form-group -->            
                                
<script>
    tinymce.init({
        selector: '#description',
        convert_urls: false,
        statusbar: false,
        menubar: false,
        //                                  forced_root_block : 'div',
   //     forced_root_block: '',
//        plugins: [
//            ' textcolor advlist autolink lists link image charmap print preview anchor',
//            'searchreplace visualblocks code fullscreen',
//            'insertdatetime media table paste code help wordcount'
//        ],
        plugins: 'image code preview searchreplace autolink directionality  visualblocks visualchars fullscreen image link  table charmap pagebreak nonbreaking insertdatetime advlist lists wordcount media ',
        toolbar: 'formatselect | bold italic strikethrough forecolor backcolor | link | alignleft aligncenter alignright alignjustify  | numlist bullist outdent indent  | removeformat |undo redo | image code| link fontsizeselect  | ',
        fontsize_formats: "8pt 9pt 10pt 11pt 12pt 14pt 18pt 24pt 30pt 36pt 48pt 60pt 72pt 96pt",

       // theme: "modern",
        height: 300,
        //    width: 680,
        cleanup: false,
        inline_styles: true,
        verify_html: false,
        extended_valid_elements: "em[class],i[class],ul[class],li[class],ol[class],*[class]|*[data-*]",

        image_title: true,
        automatic_uploads: false,
        images_upload_url: '{{url("/owner/project/upload_image")}}',
        file_picker_types: 'image media',
        file_picker_callback: function (cb, value, meta) {

            var input = document.createElement('input');
            input.setAttribute('type', 'file');
            input.setAttribute('accept', 'image/*');
            input.onchange = function () {
                var file = this.files[0];

                var reader = new FileReader();
                reader.readAsDataURL(file);
                reader.onload = function () {
                    var id = 'blobid' + (new Date()).getTime();
                    var blobCache = tinymce.activeEditor.editorUpload.blobCache;
                    var base64 = reader.result.split(',')[1];
                    var blobInfo = blobCache.create(id, file, base64);
                    blobCache.add(blobInfo);
                    cb(blobInfo.blobUri(), {title: file.name});
                };
            };
            input.click();
        },

        images_upload_handler: function (blobInfo, success, failure) {
            var xhr, formData;
            xhr = new XMLHttpRequest();
            xhr.withCredentials = false;
            xhr.open('POST', "{{url('owner/project/upload_image')}}");
            var token = '{{ csrf_token() }}';
            xhr.setRequestHeader("X-CSRF-Token", token);
            xhr.onload = function () {
                var json;
                if (xhr.status != 200) {
                    failure('HTTP Error: ' + xhr.status);
                    return;
                }
                json = JSON.parse(xhr.responseText);

                if (!json || typeof json.location != 'string') {
                    failure('Invalid JSON: ' + xhr.responseText);
                    return;
                }
                success(json.location);
            };
            formData = new FormData();
            formData.append('file', blobInfo.blob(), blobInfo.filename());
            xhr.send(formData);
        }

    });
</script>  

                                
                                
                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Status</label>
                                    <select name="status" id="status" class="form-control form-select" data-parsley-required='true'>
                                        <option value="">Select</option>            
                                        @foreach(config('constants.GENERAL_STATUS') as $key=>$status)
                                        <option value='{{$key}}' @if($key == $row->status) selected @endif>{{$status}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <!-- /.form-group -->


                         

                            </div>
                            <!-- /.col-md-12 col-12 -->


                        </div>
                        <!-- /.row -->
     
          
            
                          <div class="row mt-4 mb-4">
                                <div class="col-md-12 col-12">
                                    <div class="box-footer float-end">                
                                        <button type="submit" class="btn btn-primary pull-right"><i class="fas fa-save"></i> Save</button>
                                    </div>
                                    <!-- /.box-footer -->
                                </div>
                                <!-- /.col-md-12 col-12 -->
                            </div>
                            <!-- /.row -->

             
        </form>
        <script>$("#my_form").parsley();</script>



                    </div> 
                    <!-- /.card-body -->
<!--                    <div class="card-footer">Footer</div> -->
                    <!-- /.card-footer-->
                </div> 
                <!-- /.card -->
            </div>
        </div> 
        <!--end::Row-->
    </div>
</div>
<!--end::App Content-->




@endsection



