



@extends('owner.layouts.layout')

@section('main_content')


@include('owner.templates.content_header',['module'=>'Owner','breadcrumb'=>'Owner','breadcrumb_active'=>'Show'])



<!--begin::App Content-->
<div class="app-content"> <!--begin::Container-->
    <div class="container-fluid"> <!--begin::Row-->
        <div class="row">
            <div class="col-12"> 
                <!-- Default box -->
                <div class="card card-primary card-outline p-0">
                    <div class="card-header">
                        <!--                                    <h3 class="card-title">Title</h3>-->

                        @include('common.templates.back_button')

                        <div class="card-tools">
                            @include('common.templates.add_new_button',['url'=>'owner/owner/create'])

                        </div>
                    </div>

                    <div class="card-body table-responsive">

 <!-- form start -->
        <form class="ajax-form-submit" id="my_form" name="my_form" method="post" action="#" data-redirect-link="{{url('owner/owner')}}" enctype='multipart/form-data'>
             {{ method_field('PATCH') }}
                {{ csrf_field() }}

      


                <div class="row">

                    <div class="col-md-6 col-12">


 
                        
                        
                      <div class="form-group mb-3">
                             <label class="form-label fw-bold">Name</label>
                            <input type="text" name='name' id="name" class="form-control" id="name" placeholder="Name" data-parsley-required='true' data-parsley-pattern="^[a-zA-Z ]+$" data-parsley-pattern-message="Name Must be alphabets only" data-parsley-minlength='2'  data-parsley-maxlength='100' value="{{$row->name}}">
                        </div>
                        <!-- /.form-group -->            

                      <div class="form-group mb-3">
                             <label class="form-label fw-bold">Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Email"  data-parsley-required='true'  data-parsley-type='email' data-parsley-maxlength='100'  data-parsley-minlength='7' value="{{$row->email}}">
                        </div>
                        <!-- /.form-group -->          

      <div class="form-group mb-3">
                                     <label class="form-label fw-bold">Role</label>
                                    <select name="role" id="role" class="form-control" data-parsley-required='true'>
                                        <option value="">Select Role</option> 
                                        @if(!empty($roles) && count($roles)>0)
                                        @foreach($roles as $role)
                                        <option value='{{$role->rg_code}}|{{$role->id}}|{{$role->r_code}}' @if($row->role_id == $role->id) selected @endif>{{$role->r_name}}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                </div>
                                <!-- /.form-group -->


                        
                        <!-- /.form-group -->

                      <div class="form-group mb-3">
                             <label class="form-label fw-bold">Status</label>
                            <select name="status" id="status" class="form-control" data-parsley-required='true'>
                                <option value="">Select</option>            
                                @foreach(config('constants.USER_STATUS') as $key=>$status)
                               <option value='{{$key}}' @if($row->status == $key) selected @endif>{{$status}}</option>  
                                @endforeach
                            </select>
                        </div>
                        <!-- /.form-group -->


                    </div>



                    <div class="col-md-6 col-12">


                      <div class="form-group mb-3">
                            <label class="form-label fw-bold">Contact</label>
                           <input type="tel" name='mobile' id="mobile" class="form-control" placeholder="Contact" data-parsley-required='true' data-parsley-type='digits' data-parsley-minlength='10' data-parsley-maxlength='10' value="{{$row->mobile}}">
                        </div>
                        <!-- /.form-group -->         


                      <div class="form-group mb-3">
                            <label class="form-label fw-bold">Address</label>
                            <textarea  name="address" id="address" class="form-control" title="Address" placeholder="Address" data-parsley-required="true" style='height:124px'>{{$row->address}}</textarea>

                        </div>
                        <!-- /.form-group -->            


                      

                        
                            <div class="form-group mb-3">
                                     <label class="form-label fw-bold">Current Image</label>
                                    <div class="form-control" style="border:0px">
                                          <span class="start"><img src="{{create_image_path($row->profile_image)}}" class="img elevation-2" alt="User Image" height='150' width="150"></span>
           
                                    </div>
                                
                                </div>
                                <!-- /.form-group -->

                        

                    </div>
                    <!-- /.col-md-6 col-6 -->


                </div>
                <!-- /.row -->


          
             
        </form>
        <script>$("#my_form").parsley();</script>



                    </div> 
                    <!-- /.card-body -->
                    <!--<div class="card-footer">Footer</div>--> 
                    <!-- /.card-footer-->
                </div> 
                <!-- /.card -->
            </div>
        </div> 
        <!--end::Row-->
    </div>
</div>
<!--end::App Content-->


<script>

    $('#my_form').find('input, textarea, button, select').attr('disabled', 'disabled');
</script>


@endsection







