
@extends('owner.layouts.layout')

@section('main_content')

@include('owner.templates.content_header',['module'=>'Owners','breadcrumb'=>'Owner','breadcrumb_active'=>'Add'])


<!--begin::App Content-->
<div class="app-content"> <!--begin::Container-->
    <div class="container-fluid"> <!--begin::Row-->
        <div class="row">
            <div class="col-12"> 
                <!-- Default box -->
                <div class="card card-primary card-outline p-0">
                    <div class="card-header">
                        <!--                                    <h3 class="card-title">Title</h3>-->

                        @include('common.templates.back_button')

                        <div class="card-tools">
                            @include('common.templates.add_new_button',['url'=>'owner/owner/create'])

                        </div>
                    </div>

                    <div class="card-body table-responsive">


                            <form class="ajax-form-submit" id="my_form" name="my_form" method="post" action="{{route('owner.owner.store')}}" data-redirect-link="{{url('owner/owner')}}" enctype='multipart/form-data'>
                        {{ method_field('POST') }}
                        {{ csrf_field() }}
 
                     



                        <div class="row">

                            <div class="col-md-6 col-12">



                                

                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Name</label>
                                    <input type="text" name='name' id="name" class="form-control" id="name" placeholder="Name" data-parsley-required='true' data-parsley-pattern="^[a-zA-Z ]+$" data-parsley-pattern-message="Name Must be alphabets only" data-parsley-minlength='2'  data-parsley-maxlength='100' >
                                </div>
                                <!-- /.form-group -->            

                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Email</label>
                                    <input type="email" name="email" id="email" class="form-control" placeholder="Email"  data-parsley-required='true'  data-parsley-type='email' data-parsley-maxlength='100'  data-parsley-minlength='7'>
                                </div>
                                <!-- /.form-group -->          

                                
                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Role</label>
                                    <select name="role" id="role" class="form-control form-select" data-parsley-required='true'>
                                        <option value="">Select Role</option> 
                                        @if(!empty($roles) && count($roles)>0)
                                        @foreach($roles as $role)
                                        
                                        <option value='{{$role->rg_code}}|{{$role->id}}|{{$role->r_code}}'>{{$role->r_name}}</option>
                                        
                                        @endforeach
                                        @endif
                                    </select>
                                </div>
                                <!-- /.form-group -->

                                

<!--                                     <div class="form-group mb-3">
                                        <label for="profile_image">Profile Image</label>
                                        <div class="input-group custom-file">
                                            
                                                <input type="file" class="custom-file-input" id="exampleInputFile">
                                                 <input name="profile_image" type="file" id="profile_image" class="custosm-file-input" data-parsley-fileextension="jpg,jpeg" data-parsley-fileextension-message="File should be .jpg or .jpeg only" data-parsley-maxfilesize="2048" data-parsley-maxfilesize-message="The file must be samller than 2MB">
                                                <label class="custom-file-label" for="profile_image">Choose Image(.jpg,.jpeg)</label>
                                        

                                        </div>
                                    </div>
  -->
                                <!-- /.form-group -->

                                
                                     <div class="form-group mb-3">
                                        <label class="form-label fw-bold" for="profile_image">Profile Image</label>
                                        <div class="input-group mb-3">
                                            <input name="profile_image" type="file" id="profile_image" class="form-control" data-parsley-fileextension="jpg,jpeg" data-parsley-fileextension-message="File should be .jpg or .jpeg only" data-parsley-maxfilesize="2048" data-parsley-maxfilesize-message="The file must be samller than 2MB" data-title="Profile Image" title="profile image"> 
                                            <label class="input-group-text" for="profile_image">(.jpg,.jpeg)</label> </div>
                                    </div>

                                    <!-- /.form-group -->

                                

                                <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Status</label>
                                    <select name="status" id="status" class="form-control form-select" data-parsley-required='true'>
                                        <option value="">Select</option>            
                                        @foreach(config('constants.USER_STATUS') as $key=>$status)
                                        <option value='{{$key}}'>{{$status}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <!-- /.form-group -->


                            </div>



                            <div class="col-md-6 col-12">


                                  <div class="form-group mb-3">
                                    <label class="form-label fw-bold">Mobile</label>
                                    <input type="tel" name='mobile' id="mobile" class="form-control" placeholder="Contact" data-parsley-required='true' data-parsley-type='digits' data-parsley-minlength='10' data-parsley-maxlength='10'>
                                </div>
                                <!-- /.form-group -->         


                                  <div class="form-group mb-3">
                                    <label class="form-label fw-bold">Address</label>
                                    <textarea  name="address" id="address" class="form-control" title="Address" placeholder="Address" data-parsley-required="true" style='height: 124px;'></textarea>

                                </div>
                                <!-- /.form-group -->            


                            </div>
                            <!-- /.col-md-6 col-6 -->


                        </div>
                        <!-- /.row -->
     

                           <div class="row mt-4 mb-4">
                                <div class="col-md-12 col-12">
                                    <div class="box-footer float-end">                
                                        <button type="submit" class="btn btn-primary pull-right"><i class="fas fa-save"></i> Save</button>
                                    </div>
                                    <!-- /.box-footer -->
                                </div>
                                <!-- /.col-md-12 col-12 -->
                            </div>
                            <!-- /.row -->

                        
                        
             


                    </form>




                        <script>$("#my_form").parsley(parsley_config);</script>



                    </div> 
                    <!-- /.card-body -->
                    <!--<div class="card-footer">Footer</div>--> 
                    <!-- /.card-footer-->
                </div> 
                <!-- /.card -->
            </div>
        </div> 
        <!--end::Row-->
    </div>
</div>
<!--end::App Content-->




@endsection








