

@extends('owner.layouts.layout')

@section('main_content')


@include('owner.templates.content_header',['module'=>'Dummy','breadcrumb'=>'Dummy','breadcrumb_active'=>'List'])



<!--begin::App Content-->
<div class="app-content"> <!--begin::Container-->
    <div class="container-fluid"> <!--begin::Row-->
        
          <div class="row">
            <div class="col-12"> 
                <!-- Default box -->
                <div class="card card-primary card-outline p-0">
                    <div class="card-header">
                        <!--                                    <h3 class="card-title">Title</h3>-->

                        @include('common.templates.back_button')

                        <div class="card-tools">
                            @include('common.templates.add_new_button',['url'=>'employee/dummy/create'])

                        </div>
                    </div>

                    <div class="card-body table-responsive">


            


     <div class="row">
        <div class="col-md-3 col-12 col-lg-3">

          <!-- Profile Image -->
          <div class="box box-primary">
            <div class="box-body box-profile">
            
              <img src="{{create_image_path($row->profile_image ?? '')}}" class="profile-user-img img-responsive img-circle rounded-circle" alt="User profile picture" >

              <h3 class="profile-username text-center">{{$row->name ?? ''}}</h3>

              <p class="text-muted text-center">{{$row->role ?? ''}}</p>
<!--
              <ul class="list-group list-group-unbordered">
                <li class="list-group-item">
                  <b>Followers</b> <a class="pull-right">1,322</a>
                </li>
                <li class="list-group-item">
                  <b>Following</b> <a class="pull-right">543</a>
                </li>
                <li class="list-group-item">
                  <b>Friends</b> <a class="pull-right">13,287</a>
                </li>
              </ul>-->

              <a href="{{url('employee/employee/change_password')}}" class="btn btn-primary btn-block"><b>Change Password</b></a>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->

          <!-- About Me Box -->
          <div class="box box-primary">
            <div class="box-header with-border">
              <h3 class="box-title">About Me</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
<!--              <strong><i class="fa fa-book margin-r-5"></i> Education</strong>

              <p class="text-muted">
                B.S. in Computer Science from the University of Tennessee at Knoxville
              </p>

              <hr>-->

              <strong><i class="fa fa-map-marker margin-r-5"></i> Location</strong>

              <p class="text-muted">{{$row->address ?? ''}}</p>

              <hr>

<!--              <strong><i class="fa fa-pencil margin-r-5"></i> Skills</strong>

              <p>
                <span class="label label-danger">UI Design</span>
                <span class="label label-success">Coding</span>
                <span class="label label-info">Javascript</span>
                <span class="label label-warning">PHP</span>
                <span class="label label-primary">Node.js</span>
              </p>

              <hr>-->

              <strong><i class="fa fa-file-text-o margin-r-5"></i> Notes</strong>

              <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam fermentum enim neque.</p>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
        <div class="col-md-9 col-12 col-lg-9">
          <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
              <li class="active"><a href="#information" data-toggle="tab">Information</a></li>
              <li><a href="#change_password" data-toggle="tab">Password</a></li>
             
            </ul>
            <div class="tab-content">
              <div class="active tab-pane" id="information">
                  
                  
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name='name' id="name" class="form-control" id="name" placeholder="Name" data-parsley-required='true' data-parsley-pattern="^[a-zA-Z ]+$" data-parsley-pattern-message="Name Must be alphabets only" data-parsley-minlength='2'  data-parsley-maxlength='100' value="{{$row->name}}">
                        </div>
                        <!-- /.form-group -->            

                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" id="email" class="form-control" placeholder="Email"  data-parsley-required='true'  data-parsley-type='email' data-parsley-maxlength='100'  data-parsley-minlength='7' value="{{$row->email}}">
                        </div>
                        <!-- /.form-group -->          


               


                        <div class="form-group">
                            <label>Status</label>
                            <select name="status" id="status" class="form-control" data-parsley-required='true'>
                                <option value="">Select</option>            
                                @foreach(config('constants.USER_STATUS') as $key=>$status)
                               <option value='{{$key}}' @if($row->status == $key) selected @endif>{{$status}}</option>  
                                @endforeach
                            </select>
                        </div>
                        <!-- /.form-group -->


                  
                        <div class="form-group">
                            <label class="control-label">Contact</label>
                           <input type="tel" name='mobile' id="mobile" class="form-control" placeholder="Contact" data-parsley-required='true' data-parsley-type='digits' data-parsley-minlength='10' data-parsley-maxlength='10' value="{{$row->mobile}}">
                        </div>
                        <!-- /.form-group -->         


                        <div class="form-group">
                            <label class="control-label">Address</label>
                            <textarea  name="address" id="address" class="form-control" title="Address" placeholder="Address" data-parsley-required="true">{{$row->address}}</textarea>

                        </div>
                        <!-- /.form-group -->            

<script>

    $('#information').find('input, textarea, button, select').attr('disabled','disabled');
</script>

                  
                  
              </div>
              <!-- /.tab-pane -->
              <div class="tab-pane" id="change_password">
                <!-- The timeline -->
                    <form class="form-horizontal" id="my_form" action="{{url('admin/employee/change_password')}}" method="post" enctype="multipart/form-data" >
                        {{ csrf_field() }}
                                    {{ method_field('POST') }}
                  <div class="form-group">
                    <label for="password" class="col-sm-2 control-label">Current Password</label>

                    <div class="col-sm-10">
                        <input name="current_password" type="password" class="form-control" id="password" placeholder="Current Password" data-parsley-required="true" data-parsley-minlength="6"  data-parsley-maxlength="30">
                    </div>
                  </div>
                       
                  <div class="form-group">
                    <label for="new_password" class="col-sm-2 control-label">New Password</label>

                    <div class="col-sm-10">
                      <input name="new_password" type="password"  class="form-control" id="new_password" placeholder="New Password" data-parsley-required="true" data-parsley-minlength="6"  data-parsley-maxlength="30">
                    </div>
                  </div>
                       
                  <div class="form-group">
                    <label for="confirm_password" class="col-sm-2 control-label">Confirm Password</label>

                    <div class="col-sm-10">
                      <input name="confirm_password" type="password" class="form-control" id="confirm_password" placeholder="Confirm Password" data-parsley-required="true" data-parsley-minlength="6"  data-parsley-maxlength="30" data-parsley-equalto="#new_password" data-parsley-equalto-message="Confirm password does not match"/>
                    </div>
                  </div>
                       
                 
                  <div class="form-group">
                    <div class="col-sm-offset-2 col-sm-10">
                      <button type="submit" class="btn btn-danger">Submit</button>
                    </div>
                  </div>
                </form>
                
                  <script>$("#my_form").parsley();</script>
              </div>
              <!-- /.tab-pane -->

           
            </div>
            <!-- /.tab-content -->
          </div>
          <!-- /.nav-tabs-custom -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->








                    </div> 
                    <!-- /.card-body -->
                    <!--<div class="card-footer">Footer</div>--> 
                    <!-- /.card-footer-->
                </div> 
                <!-- /.card -->
            </div>
        </div> 
        <!--end::Row-->
        
        
         
    </div>
</div>
<!--end::App Content-->

@endsection
















