
@extends('owner.layouts.layout')

@section('main_content')

@include('owner.templates.content_header',['module'=>'Document','breadcrumb'=>'Document','breadcrumb_active'=>'Add'])


<!--begin::App Content-->
<div class="app-content"> <!--begin::Container-->
    <div class="container-fluid"> <!--begin::Row-->
        <div class="row">
            <div class="col-12"> 
                <!-- Default box -->
                <div class="card card-primary card-outline p-0">
                    <div class="card-header">
                        <!--                                    <h3 class="card-title">Title</h3>-->

                        @include('common.templates.back_button')

                        <div class="card-tools">
                            @include('common.templates.add_new_button',['url'=>'owner/document/create'])

                        </div>
                    </div>

                    <div class="card-body table-responsive">


                            <form class="ajax-form-submit" id="my_form" name="my_form" method="post" action="{{route('owner.document.store')}}" data-redirect-link="{{url('owner/document')}}" enctype='multipart/form-data'>
                        {{ method_field('POST') }}
                        {{ csrf_field() }}
 
                     



                        <div class="row">

                            <div class="col-md-12 col-12">



                                

                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Name</label>
                                    <input type="text" name='name' id="name" class="form-control"  placeholder="Name" data-parsley-required='true' data-parsley-minlength='2'  data-parsley-maxlength='100' >
                                </div>
                                <!-- /.form-group -->            

                             

                                
                                     <div class="form-group mb-3">
                                        <label class="form-label fw-bold" for="file">Image</label>
                                        <div class="input-group mb-3">
                                            <input name="file" type="file" id="file" data-parsley-required="true" class="form-control" data-parsley-fileextension="pdf,docx,xlsx" data-parsley-fileextension-message="File should be .pdf or .docx or .xlsx only" data-parsley-maxfilesize="5120" data-parsley-maxfilesize-message="The file must be samller than 5MB" data-title="File" title="File"> 
                                            <label class="input-group-text" for="file">(.pdf,.docx,.xlsx)</label> </div>
                                    </div>

                                    <!-- /.form-group -->

                                

                              
     

                                
                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Status</label>
                                    <select name="status" id="status" class="form-control form-select" data-parsley-required='true'>
                                        <option value="">Select</option>            
                                        @foreach(config('constants.GENERAL_STATUS') as $key=>$status)
                                        <option value='{{$key}}'>{{$status}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <!-- /.form-group -->


                         

                            </div>
                            <!-- /.col-md-12 col-12 -->


                        </div>
                        <!-- /.row -->
     

                           <div class="row mt-4 mb-4">
                                <div class="col-md-12 col-12">
                                    <div class="box-footer float-end">                
                                        <button type="submit" class="btn btn-primary pull-right"><i class="fas fa-save"></i> Save</button>
                                    </div>
                                    <!-- /.box-footer -->
                                </div>
                                <!-- /.col-md-12 col-12 -->
                            </div>
                            <!-- /.row -->

                        
                        
             


                    </form>




                        <script>$("#my_form").parsley(parsley_config);</script>



                    </div> 
                    <!-- /.card-body -->
                    <!--<div class="card-footer">Footer</div>--> 
                    <!-- /.card-footer-->
                </div> 
                <!-- /.card -->
            </div>
        </div> 
        <!--end::Row-->
    </div>
</div>
<!--end::App Content-->




@endsection








