
 @extends('owner.auth.layout.login_layout')

@section('main_content')
<div class="container mt-5">
  <div class="row justify-content-center">
    <div class="col-md-5">
      <div class="card">
        <div class="card-header bg-success text-white">Owner - Reset Password</div>
        <div class="card-body">

          <form id="ownerResetForm" method="POST" action="{{ route('owner.password.update') }}">
            @csrf
            <input type="hidden" name="token" value="{{ $token }}">

            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" value="{{ $email ?? old('email') }}" required>
              @error('email') <small class="text-danger">{{ $message }}</small> @enderror
            </div>

            <div class="mb-3">
              <label class="form-label">New Password</label>
              <input type="password" name="password" class="form-control" required>
              @error('password') <small class="text-danger">{{ $message }}</small> @enderror
            </div>

            <div class="mb-3">
              <label class="form-label">Confirm Password</label>
              <input type="password" name="password_confirmation" class="form-control" required>
            </div>

            <button class="btn btn-success w-100" type="submit">Reset Password</button>
          </form>

          <div id="ownerResetMsg" class="mt-3"></div>

        </div>
      </div>
    </div>
  </div>
</div>
  $(function () {
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
      increaseArea: '20%' /* optional */
    });
  });
</script>-->
@endsection




    
