
 @extends('owner.auth.layout.login_layout')

@section('main_content')

<div class="container mt-5">
  <div class="row justify-content-center">
    <div class="col-md-5">
      <div class="card">
        <div class="card-header bg-primary text-white">Owner - Forgot Password</div>
        <div class="card-body">
          @if(session('success')) <div class="alert alert-success">{{ session('success') }}</div> @endif

          <form id="ownerForgotForm" method="POST" action="{{ route('owner.password.email') }}">
            @csrf
            <div class="mb-3">
              <label class="form-label">Email</label>
              <input type="email" name="email" class="form-control" required>
              @error('email') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
            <button type="submit" class="btn btn-primary w-100">Send Reset Link</button>
          </form>

          <div id="ownerForgotMsg" class="mt-3"></div>

        </div>
      </div>
    </div>
  </div>
</div>


<!--<script>
  $(function () {
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
      increaseArea: '20%' /* optional */
    });
  });
</script>-->
@endsection




    
