<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <!-- Bootstrap 5 CSS -->
<!--    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">-->
    
          <link rel="stylesheet" href="https://unpkg.com/bootstrap@5.3.2/dist/css/bootstrap.min.css">

       <!-- <link href="{{asset('public/front/assets/vendor/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet"> -->
  <link href="{{asset('public/front/assets/vendor/bootstrap-icons/bootstrap-icons.css')}}" rel="stylesheet">
    <style>
        body, html {
            height: 100%;
            margin: 0;
            /* Use your AI-generated image here */
            background: url('{{asset("public/front/assets/img/login_bg.jpg")}}') no-repeat center center fixed;  
            background-size: cover;
            font-family: Arial, sans-serif;
        }

        /* Centering the content vertically and horizontally */
        .container-fullheight {
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            /* backdrop-filter: blur(5px);*/ /* Optional: add blur effect on background */
        }

        /* Blurring effect on links when clicked */
        .blurred {
            filter: blur(5px);
        }
       

        /* Styling the container for the buttons to make them in a square without gaps */
        .button-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);  /* 2 columns */
            gap: 0;  /* No gap between buttons */
            width: 300px;
            text-align: center;
            background-color: rgba(255, 255, 255, 0.8); /* Slight white background for readability */
            padding: 20px;
            border-radius: 10px; /* Optional: rounded corners */
        }

        .button-container .btn {
            width: 100%;
            padding: 20px;
            font-size: 18px;
            border-radius: 0; /* Remove border radius if you want the buttons to align exactly */
        }

        /* Styling the modal and form */
        .modal-dialog {
            max-width: 500px;
        }
    </style>
    
    
          <!-- jQuery -->
<script src="{{asset('public/plugins/jquery/jquery.min.js')}}"></script>
<!-- jQuery UI 1.11.4 -->
<script src="{{asset('public/plugins/jquery-ui/jquery-ui.min.js')}}"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    

    
   <link rel="stylesheet" href="{{asset('public/css/flash_messages_new.css')}}">

</head>
<body>
    
          <!-- =======================
✅ Use in view:
======================= -->
    
    <div style="text-align: center; padding-left: 20px; padding-right: 20px;padding-top:2px;">
            @include('common.templates.flash_message_all')
    </div> 
          
       @include('common.templates.ajax_div')
       
   



    <!-- Container to center the content -->
    <div class="container-fluid container-fullheight" style="width:500px" >
        <div class="text-center" style="width:500px">
            <h2>Select Your Login</h2>
     
             
<style>

</style>
     
 <div class="" id="login-status"></div>

 
    <form class="ajax-form-ssssubmit" id="login-form" action="{{route('superadmin.authenticate')}}" method="post" data-redirect-link="{{route('superadmin.dashboard')}}">
             @csrf
             
            <div class="input-group mb-3"> 
            <input type="text" name="email" id="email" class="form-control @error('email') is-invalid @enderror" placeholder="Employee Id" data-parsley-required="true" value="{{old('email')}}">
                <div class="input-group-text"> 
                    <span class="bi bi-envelope"></span> 
                </div>
                 
                @error('email')
                    <p class="invalid-feedback">{{$message}}</p>
                @enderror                              
                                              
            </div> 
            <div class="input-group mb-3"> 
                <input type="password" name="password" id="password" class="form-control @error('password') is-invalid @enderror" placeholder="Password" data-parsley-required="true">
                <div class="input-group-text"> 
                    <span class="bi bi-lock-fill"></span> 
                </div>
                @error('password')
                    <p class="invalid-feedback">{{$message}}</p>
                @enderror
            </div> 
            <div class="form-check mb-2"> 
                <input type="checkbox" name="remember"  id="remember" class="form-check-input" > 
                <label class="form-check-label" for="remember">
                    Remember Me
                </label> 
            </div>
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
      </form>
      



            <!-- Container for the buttons arranged in a square -->
            <div class="button-container" style="width:500px">               
                
                <button href="#" class="btn btn-primary" onclick="openLoginModal('form1')">Owner</button>
                <button href="#" class="btn btn-secondary" onclick="openLoginModal('form2')">Employee</button>
                <button href="#" class="btn btn-success" onclick="openLoginModal('form3')">Parent</button>
                <button href="#" class="btn btn-danger" onclick="openLoginModal('form4')">Student</button>
            </div>
        </div>
    </div>
 
    <!-- Modal Structure -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="loginModalLabel">Login</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                       
        
                <div class="modal-body" id="modalFormContent">
                    <!-- Login forms will be injected here -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Form 1 -->
    <div id="form1" style="display: none;">
        <h3>Login Owner</h3>
        
      <form class="ajax-form-submit" id="login-form-owner" action="{{route('owner.authenticate')}}" method="post" data-redirect-link="{{route('owner.dashboard')}}">
             @csrf
             
            <div class="input-group mb-3"> 
            <input type="text" name="email" id="user_unique_id" class="form-control @error('email') is-invalid @enderror" placeholder="Employee Id" data-parsley-required="true" value="{{old('email')}}">
                <div class="input-group-text"> 
                    <span class="bi bi-envelope"></span> 
                </div>
                 
                @error('email')
                    <p class="invalid-feedback">{{$message}}</p>
                @enderror                              
                                              
            </div> 
            <div class="input-group mb-3"> 
                <input type="password" name="password" id="password" class="form-control @error('password') is-invalid @enderror" placeholder="Password" data-parsley-required="true">
                <div class="input-group-text"> 
                    <span class="bi bi-lock-fill"></span> 
                </div>
                @error('password')
                    <p class="invalid-feedback">{{$message}}</p>
                @enderror
            </div> 
            <div class="form-check mb-2"> 
                <input type="checkbox" name="remember"  id="remember" class="form-check-input" > 
                <label class="form-check-label" for="remember">
                    Remember Me
                </label> 
            </div>
            <button type="submit" class="btn btn-primary btn-block">Sign In</button>
      </form>
       
    </div>

    <!-- Form 2 -->
    <div id="form2" style="display: none;">
        <h3>Login Employee</h3>
        <form  class="ajax-form-submit" id="login-form-employee" action="{{route('employee.authenticate')}}" method="post" data-redirect-link="{{route('employee.dashboard')}}">
            @csrf
            <div class="mb-3">
                <label for="email2" class="form-label">Email address</label>
                <input type="text" name="email" class="form-control" id="email2" placeholder="Enter email">
            </div>
            <div class="mb-3">
                <label for="password2" class="form-label">Password</label>
                <input type="password" name="password" class="form-control" id="password2" placeholder="Password">
            </div>
            <button type="submit" class="btn btn-secondary">Login</button>
        </form>
    </div>

    <!-- Form 3 -->
    <div id="form3" style="display: none;">
        <h3>Login Parent</h3>
        <form class="ajax-form-submit" id="login-form-parent" action="{{route('parent.authenticate')}}" method="post" data-redirect-link="{{route('parent.dashboard')}}">
            @csrf
            <div class="mb-3">
                <label for="email3" class="form-label">Email address</label>
                <input type="email" name="email" class="form-control" id="email3" placeholder="Enter email">
            </div>
            <div class="mb-3">
                <label for="password3" class="form-label">Password</label>
                <input type="password" name="password" class="form-control" id="password3" placeholder="Password">
            </div>
            <button type="submit" class="btn btn-success">Login</button>
        </form>
    </div>

    <!-- Form 4 -->
    <div id="form4" style="display: none;">
        <h3>Login Student</h3>
        <form  class="ajax-form-submit" id="login-form-student" action="{{route('student.authenticate')}}" method="post" data-redirect-link="{{route('student.dashboard')}}">
            @csrf
            <div class="mb-3">
                <label for="email4" class="form-label">Email address</label>
                <input type="email" name="email" class="form-control" id="email4" placeholder="Enter email">
            </div>
            <div class="mb-3">
                <label for="password4" class="form-label">Password</label>
                <input type="password" name="password" class="form-control" id="password4" placeholder="Password">
            </div>
            <button type="submit" class="btn btn-danger">Login</button>
        </form>
    </div>

    <!-- Bootstrap 5 JS and Popper.js -->
<!--    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>-->
<!--    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>-->
    
     <script src="{{asset('public/adminlte_4.0.0/cdn_files/popper.js')}}" ></script> 
   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous"></script>

    <script>
        // Function to open the login modal with the selected form content
        function openLoginModal(formId) {
            // Blur all links
            const links = document.querySelectorAll('#login-links a');
            links.forEach(link => link.classList.add('blurred'));

            // Get the form content and inject it into the modal body
            const formContent = document.getElementById(formId).innerHTML;
            document.getElementById('modalFormContent').innerHTML = formContent;

            // Show the modal
            const loginModal = new bootstrap.Modal(document.getElementById('loginModal'));
            loginModal.show();
         
        }

        // Optional: Reset blur effect when the modal is closed
        const modalElement = document.getElementById('loginModal');
        modalElement.addEventListener('hidden.bs.modal', function () {
            const links = document.querySelectorAll('#login-links a');
            links.forEach(link => link.classList.remove('blurred'));
        });
    </script>
    
    
   
<!--
 *
 *
 *
 * MY created scripts are included below
 *
 *
 *
 *
 *
-->

<script src="{{asset('public/js/config_file.js')}}"></script>
<script src="{{asset('public/tools/Parsley.js-2.9.2/dist/parsley.js')}}"></script>
<script src="{{asset('public/tools/Parsley.js-2.9.2/dist/parsley-custom-validators.js')}}"></script>
<script src="{{asset('public/js/ajax_form_submit.js')}}"></script>



  <!-- Flash Messages -->
  <!-- <link rel="stylesheet" href="{{asset('public/css/flash_messages.css')}}"> -->
  <link rel="stylesheet" href="{{asset('public/tools/Parsley.js-2.9.2/dist/parsley.css')}}">
  <link rel="stylesheet" href="{{asset('public/css/my_grid.css')}}">

  

<script src="{{asset('public/js/custom_scripts.js')}}"></script>
<script src="{{asset('public/js/my_scripts.js')}}"></script>
  

</script>
</body>
</html>

