<nav class="paging" aria-label="Page navigation example">

@if ($paginator->hasPages())
<ul class="pagination">
    {{-- Previous Page Link --}}
    @if ($paginator->onFirstPage())
       
         <li class="page-item disabled"><span class="page-link"><i class="fas fa-angle-double-left"></i></span></li>
    @else
   
        <li class="page-item"><a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev"><i class="fas fa-angle-double-left"></i></a></li>
    @endif

    {{-- Pagination Elements --}}
    @foreach ($elements as $element)
        {{-- Array Of Links --}}
        @if (is_array($element))
            @foreach ($element as $page => $url)
                @if ($page === $paginator->currentPage())
<!--                    <li class="active page-item"><span>{{ $page }}</span></li>-->
                    <li class="page-item active"><span class="page-link">{{ $page }}</span></li>
                @elseif (($page === $paginator->currentPage() + 1 || $page === $paginator->currentPage() + 2)
                 || $page === $paginator->lastPage())

                     <li class="page-item"><a class="page-link" href="{{ $url }}">{{ $page }}</a></li>
                @elseif ($page === $paginator->lastPage()-1)
                    <li class="disabled"><span class="page-link">...</span></li>
                @endif
            @endforeach
        @endif
    @endforeach

    {{-- Next Page Link --}}
    @if ($paginator->hasMorePages())
        <li class="page-item"><a class="page-link page" href="{{ $paginator->nextPageUrl() }}" rel="next"><i class="fas fa-angle-double-right"></i></a></li>
    @else
        <li class="page-item disabled"><span class="page-link"><i class="fas fa-angle-double-right"></i></span></li>
    @endif
    <li style="display:none;"><a class="total page-link page" data-total="{{$paginator->lastPage()}}" > Pages {{$paginator->lastPage()}}</a></li>
    
</ul>
@endif
    </nav>