@extends('front.layouts.layout')

@section('main_content')



  <main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">Pricing</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{ url('/') }}">Home</a></li>
            <li class="current">Pricing</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Pricing Section -->
    <section id="pricing" class="pricing section">

      <div class="container">

        <div class="row gy-3">
            
             @if(!empty($packages))
                    @foreach($packages as $package)
                    @php
                    $package_total = 0;
                    foreach($package->package_module as $module){
                    $package_total = $package_total + $module->module->m_rate;
                    }  
                    @endphp
                                                
                    <div class="col-xl-3 col-lg-6" data-aos="fade-up" data-aos-delay="200">
                        <div class="pricing-item featured">
                          <h3>{{$package->name}}</h3>
                          <h4><sup><i class="bi bi-currency-rupee"></i></sup>{{$package_total}}<span> / Year</span></h4>
                          <ul>
                            <li>
                                Total {{$package->package_module->count()}} Modules
                            </li>
                            <li>Nec feugiat nisl</li>
                            <li>Nulla at volutpat dola</li>
                            <li>Pharetra massa</li>
                            <li class="na">Massa ultricies mi</li>
                          </ul>
                          <div class="btn-wrap">
                            <a href="{{url('owner/register')}}" class="btn-buy">Buy Now</a>
                          </div>
                        </div>
                    </div>
                        <!-- End Pricing Item -->
                                            
                    @endforeach

                    @else

                    @endif

            
            
            
            
            
            
<!--          <div class="col-xl-3 col-lg-6" data-aos="fade-up" data-aos-delay="100">
            <div class="pricing-item">
              <h3>Free</h3>
              <h4><sup>$</sup>0<span> / month</span></h4>
              <ul>
                <li>Aida dere</li>
                <li>Nec feugiat nisl</li>
                <li>Nulla at volutpat dola</li>
                <li class="na">Pharetra massa</li>
                <li class="na">Massa ultricies mi</li>
              </ul>
              <div class="btn-wrap">
                <a href="#" class="btn-buy">Buy Now</a>
              </div>
            </div>
          </div>-->
            <!-- End Pricing Item -->

         
<!--
          <div class="col-xl-3 col-lg-6" data-aos="fade-up" data-aos-delay="400">
            <div class="pricing-item featured">
              <h3>Developer</h3>
              <h4><sup>$</sup>29<span> / month</span></h4>
              <ul>
                <li>Aida dere</li>
                <li>Nec feugiat nisl</li>
                <li>Nulla at volutpat dola</li>
                <li>Pharetra massa</li>
                <li>Massa ultricies mi</li>
              </ul>
              <div class="btn-wrap">
                <a href="#" class="btn-buy">Buy Now</a>
              </div>
            </div>
          </div>-->
            <!-- End Pricing Item -->

<!--          <div class="col-xl-3 col-lg-6" data-aos="fade-up" data-aos-delay="400">
            <div class="pricing-item featured">
              <span class="advanced">Advanced</span>
              <h3>Ultimate</h3>
              <h4><sup>$</sup>49<span> / month</span></h4>
              <ul>
                <li>Aida dere</li>
                <li>Nec feugiat nisl</li>
                <li>Nulla at volutpat dola</li>
                <li>Pharetra massa</li>
                <li>Massa ultricies mi</li>
              </ul>
              <div class="btn-wrap">
                <a href="#" class="btn-buy">Buy Now</a>
              </div>
            </div>
          </div>-->
            <!-- End Pricing Item -->

        </div>

      </div>

    </section><!-- /Pricing Section -->

  </main>

@endsection