<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8" />
<title>Password Reset</title>
<style>
/* email-safe simple styles */
.container { max-width:600px; margin:0 auto; font-family:Arial, sans-serif; background:#fff; border:1px solid #e9ecef; border-radius:6px; overflow:hidden; }
.header { background:#0d6efd; color:#fff; padding:18px; text-align:center; font-size:18px; }
.content { padding:24px; color:#212529; }
.btn { display:inline-block; padding:12px 22px; background:#0d6efd; color:#fff; text-decoration:none; border-radius:6px; font-weight:600; }
.footer { padding:16px; text-align:center; color:#6c757d; font-size:13px; }
</style>
</head>
<body>
<div class="container">
  <div class="header">Reset Your Password</div>
  <div class="content">
    <p>Hello {{ $user->name ?? 'User' }},</p>
    <p>We received a request to reset your password. Click the button below to reset it.</p>
    <p style="text-align:center; margin:20px 0;">
      <a class="btn" href="{{ $url }}">Reset Password</a>
    </p>
    <p>If you didn't request a password reset, you can ignore this message.</p>
    <p>Thanks,<br>{{ config('app.name') }}</p>
  </div>
  <div class="footer">© {{ date('Y') }} {{ config('app.name') }}</div>
</div>
</body>
</html>
