/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

//***********  NOTE the " %s " is the input provided by user which only shows in messages

window.Parsley.addValidator('multipleof', {
    requirementType: 'integer',
    validateNumber: function (value, requirement) {
        return 0 === value % requirement;
    },
    messages: {
        en: 'This value should be a multiple of %s',
        fr: 'Cette valeur doit être un multiple de %s'
    }
});

window.Parsley.addValidator('greaterthan', {
    validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        return value > requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be greater than %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});
window.Parsley.addValidator('greaterthanreference', {
    validateString: function (value, refOrValue) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var $reference = $(refOrValue);
        if ($reference.length){ 
            return value > $reference.val();
        }else{
            return value === refOrValue;
        }
        
       // priority: 256
      //  return value >= requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be greater than %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});
window.Parsley.addValidator('greaterthanequalto', {
    validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        return value >= requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be greater than or equal to %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});
window.Parsley.addValidator('greaterthanequaltoreference', {
    validateString: function (value, refOrValue) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var $reference = $(refOrValue);
        if ($reference.length){ 
            return value >= $reference.val();
        }else{
            return value === refOrValue;
        }
        
        priority: 256
      //  return value >= requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be greater than or equal to %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});

// equalto: {
//        validateString: function validateString(value, refOrValue) {
//          if (!value) return true; // Builtin validators all accept empty strings, except `required` of course
//
//          var $reference = $(refOrValue);
//          if ($reference.length) return value === $reference.val();else return value === refOrValue;
//        },
//        priority: 256
//      }
window.Parsley.addValidator('smallerthan', {
    validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        return value < requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be smaller than %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});
window.Parsley.addValidator('smallerthanreference', {
    validateString: function (value, refOrValue) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var $reference = $(refOrValue);
        if ($reference.length){ 
            return value < $reference.val();
        }else{
            return value === refOrValue;
        }
        
       // priority: 256
      //  return value >= requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be smaller than %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});
window.Parsley.addValidator('smallerthanequalto', {
    validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        return value <= requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be smaller than or equal to %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});
window.Parsley.addValidator('smallerthanequaltoreference', {
    validateString: function (value, refOrValue) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var $reference = $(refOrValue);
        if ($reference.length){ 
            return value <= $reference.val();
        }else{
            return value === refOrValue;
        }
        
        priority: 256
      //  return value >= requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should be smaller than or equal to %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});


window.Parsley.addValidator('notequalto', {
    validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        return value != requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should not be equal to %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});
window.Parsley.addValidator('notequaltoreference', {
    validateString: function (value, refOrValue) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var $reference = $(refOrValue);
        if ($reference.length){ 
            return value != $reference.val();
        }else{
            return value === refOrValue;
        }
        
        priority: 256
      //  return value >= requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This value should not be equal to %s '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});

window.Parsley.addValidator('ajaxexists', {
    validateString: function (value, url) {
       // alert(value);
        // Zippopotam.us returns a status 404 for incorrect zip codes,
        // so we simply return the ajax request:
        // 
        // 
        // 
        // PHP should retrun ( return http_response_code(404);) for validation faluire else return http_response_code(200);
        // like if email already exist return http_response_code(404); else return http_response_code(200);
        //
        //
        //                                     OR 
        //
        //if unique id not present in database return http_response_code(404); else return http_response_code(200);
        //
        // below is example of php function
//     public function ajax_test() {
//        if (!Auth::check_perm_by_db(8, 'can_delete')) {
//                throw new Exception('Permission denied', 998);
//        }
//        $params = App::$router->get_params();
//        if (isset($params[0])) {
//            $data = array();

//            $data['unique_id'] = trim($params[0]);
//               $sth = $this->model->check_valid_unique_id($data);
//               if($sth['status'] == true){
//                   $response_code = 200;
//               }else{
//                   $response_code = 400;
//               }
//           
//        } else {
//            $response_code = 400;
//        }
//   
//  return http_response_code($response_code);
//    }
//
//     
//console.log($.ajax(url + '/' + value));

        return $.ajax(url + '/' + value);
    },
    messages: {en: 'Something not correct with this value'}
});




window.Parsley.addValidator('palindrome', {
    validateString: function (value) {
        return value.split('').reverse().join('') === value;
    },
    messages: {
        en: 'This string is not the reverse of itself',
        //fr: "Cette valeur n'est pas l'inverse d'elle même."
    }
});

// window.Parsley.addValidator('maxFileSize', {
window.Parsley.addValidator('maxfilesize', {
    validateString: function (_value, maxSize, parsleyInstance) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var files = parsleyInstance.$element[0].files;
        return files.length != 1 || files[0].size <= maxSize * 1024;
    },
    requirementType: 'integer',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This file should not be larger than %s KB'
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});

window.Parsley.addValidator('fileextension', {
    validateString: function (_value, requirement, parsleyInstance) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var file = parsleyInstance.$element[0].files;
        if (file.length == 0) {
            return true;
        }
        var fileExtension = _value.split('.').pop();

        var allowedMimeTypes = requirement.replace(/\s/g, "").split(',');
        //alert(allowedMimeTypes);
//                if ( allowedMimeTypes.indexOf( fileExtension ) > -1 ){
//                    alert('present');
//                }

        //return allowedMimeTypes.indexOf(file[0].type) !== -1;
        return allowedMimeTypes.indexOf(fileExtension) > -1;

    },
    requirementType: 'string',
    messages: {
        // en: 'File Extension not supported',
        en: 'File Extension not supported'
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }



    // $("#myForm").parsley();

});
 window.Parsley.addValidator('nospace', {
    validateString: function (value) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }       
        var value_split = value.split(" ");       
        return value_split.length == 1;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This field must not contain space '
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});

   window.Parsley.addValidator('datemysql', {
            validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var DateEntered = value;
        var D, d=DateEntered.split(/\D+/);
        d[0]*=1;
        d[1]-=1;
        d[2]*=1;
        var output = false;
        D=new Date(d[0],d[1],d[2]);
        if(DateEntered.match(/^[0-9]{4}\-(0[1-9]|1[012])\-(0[1-9]|[12][0-9]|3[01])/))
        {
          output = true;
        }
        
        if(D.getFullYear()== d[0] && D.getMonth()== d[1] && D.getDate()== d[2]) {
            output = true ;
        }else{
            output = false;
        };
   

        
        return output;
    },
    requirementType: 'string',
    messages: {        
        en: 'Invalid Date: Correct Format is YYYY-MM-DD'
     
    }
});




























 window.Parsley.addValidator('mindate', {
    validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        
         var timestamp = Date.parse(value),
           minTs = Date.parse(requirement);
        return isNaN(timestamp) ? false : timestamp >= minTs;
        //return value != requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This date should be greater than %s'
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});


 window.Parsley.addValidator('maxdate', {
    validateString: function (value, requirement) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        
         var timestamp = Date.parse(value),
           minTs = Date.parse(requirement);
        return isNaN(timestamp) ? false : timestamp <= minTs;
        //return value != requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This date should be smaller than %s'
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});


 window.Parsley.addValidator('mindatereference', {
    validateString: function (value, refOrValue) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var $reference = $(refOrValue).val();
       // alert($reference);
         var timestamp = Date.parse(value),
           minTs = Date.parse($reference);
        return isNaN(timestamp) ? false : timestamp > minTs;
        //return value != requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This date should be greater than %s'
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});

window.Parsley.addValidator('maxdatereference', {
    validateString: function (value, refOrValue) {
        if (!window.FormData) {
            alert('You are making all developers in the world cringe. Upgrade your browser!');
            return true;
        }
        var $reference = $(refOrValue).val();
       // alert($reference);
         var timestamp = Date.parse(value),
           minTs = Date.parse($reference);
        return isNaN(timestamp) ? false : timestamp < minTs;
        //return value != requirement;
    },
    requirementType: 'string',
    messages: {
        // en: 'This file should not be larger than %s KB',
        //alert(%s);
        en: 'This date should be smaller than %s'
                //fr: 'Ce fichier est plus grand que %s Kb.'
    }
});


/*
 * 
 * 
 * 
 * 
 *   <form id="myForm" data-parsley-validate="true" method="post">
                        <input type="file" name="some-file" data-parsley-fileextension='zip,mp3,jpg,jpeg' data-parsley-maxfilesize="420" multiple="true" data-parsley-required="true" data-parsley-maxfilesize-message="This file should not be larger than 420 kb"/>

                        <input type="text" name="some-thing" data-parsley-required='true' data-parsley-ajaxexists="<?php echo BASE_URL; ?>user/ajax_test" class="form-control" placeholder="For ajax test url shold be given"/>
                        
                        <input type="text" data-parsley-greaterthan="5" class="form-control" placeholder=" greater than 5"/>
                        <input type="text" data-parsley-greaterthanequalto="5" class="form-control" placeholder=" greater than equal to 5"/>
                        <input type="text" data-parsley-smallerthan="5" class="form-control" placeholder=" smaller than 5"/>
                        <input type="text" data-parsley-smallerthanequalto="5" class="form-control" placeholder=" smaller than equal to 5"/>
                        <input type="text" data-parsley-notequalto="5" class="form-control" placeholder=" not equal to 5"/>
                        <input type="text" data-parsley-multipleof="5" class="form-control" placeholder=" Multiple of 5"/>
                        <input type="text" data-parsley-palindrome="true" class="form-control" placeholder=" Palindrome"/>
                       
                        <input type="submit" class="btn btn-primary"/>




                    </form>
 * 
 * 
 */