   function set_cookie(cookie_name, value, expiry) {
  const date = new Date();
  date.setTime(date.getTime() + (expiry * 24 * 60 * 60 * 1000));
  var expires = "expires="+date.toUTCString();
  document.cookie = cookie_name + "=" + value + ";" + expires + ";path=/";
} 
        
function get_cookie(cookie_name) {
  let name = cookie_name + "=";
  let spli = document.cookie.split(';');
  for(var j = 0; j < spli.length; j++) {
    let char = spli[j];
    while (char.charAt(0) == ' ') {
      char = char.substring(1);
    }
    if (char.indexOf(name) == 0) {
      return char.substring(name.length, char.length);
    }
  }
  return "";
}   

function delete_all_cookies() {
    const cookies = document.cookie.split(";");

    for (let i = 0; i < cookies.length; i++) {
        const cookie = cookies[i];
        const eqPos = cookie.indexOf("=");
        const name = eqPos > -1 ? cookie.substr(0, eqPos) : cookie;
        document.cookie = name + "=;expires=Thu, 01 Jan 1970 00:00:00 GMT";
    }
}

function set_dark_mode(){
    var dark_mode_switch = document.getElementById('dark_mode_switch');
    
     var body_element = document.body;
            var main_header = document.getElementById('main_header');
            var main_header_class = main_header.classList;
            var main_sidebar = document.getElementById('main_sidebar');
            var main_sidebar_class = main_sidebar.classList;
            var main_sidebar_newclass = '';
            
     body_element.classList.remove("light-mode");
                body_element.classList.add("dark-mode");

                main_header_class.replace('navbar-light', 'navbar-dark')
                main_header_class.replace('navbar-white', 'navbar-dark')
                main_header.className = main_header_class;

                
                main_sidebar_class.forEach(replace_light);
                function replace_light(class_name) {
                    var replaced_class_name = class_name.replace('light', 'dark')
                    main_sidebar_newclass += " " + replaced_class_name;
                }
                
                main_sidebar.className = main_sidebar_newclass;
           
        document.getElementById("dark_mode_switch").checked = true;    
        document.cookie = 'dark_mode=1'
     
}

function set_light_mode(){
     var dark_mode_switch = document.getElementById('dark_mode_switch');
    
     var body_element = document.body;
            var main_header = document.getElementById('main_header');
            var main_header_class = main_header.classList;
            var main_sidebar = document.getElementById('main_sidebar');
            var main_sidebar_class = main_sidebar.classList;
            var main_sidebar_newclass = '';
            
                 body_element.classList.remove("dark-mode");
                body_element.classList.add("light-mode");
                main_header_class.replace('navbar-dark', 'navbar-light')

                main_header.className = main_header_class;
                main_header.classList.add('navbar-white');

                main_sidebar_class.forEach(replace_dark);
                function replace_dark(class_name) {
                    var replaced_class_name = class_name.replace('dark', 'light')
                    main_sidebar_newclass += " " + replaced_class_name;
                }
                main_sidebar.className = main_sidebar_newclass;
                
               // setCookie('dark_mode',0,1);
       document.getElementById("dark_mode_switch").checked = false;             
              //  var dark_mode_check = getCookie('dark_mode');
                 document.cookie = 'dark_mode=0'
               //  alert(dark_mode_check);
}



        var darkMode = document.getElementById('dark_mode_switch');

        darkMode.addEventListener('change', function () {
           
            if (darkMode.checked) {
                
                set_dark_mode();
               
              
            } else {
   
               set_light_mode();
            
            }
        });


      
    var dark_mode = get_cookie('dark_mode');
   // console.log(dark_mode);
    if(dark_mode != '' && dark_mode == 1){
        set_dark_mode();
    }else if(dark_mode != '' && dark_mode == 0){
        set_light_mode();
    }
    
    //delete_all_cookies();