<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Foundation\AliasLoader;


use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Cache;
use App\Models\rbac\ModuleRolePermission;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Auth;

class AppServiceProvider extends ServiceProvider
{

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
       
    
    }

    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
        // Register Milon Barcode provider
        //$this->app->register(\Milon\Barcode\BarcodeServiceProvider::class);


        // Register the alias dynamically
        $loader = AliasLoader::getInstance();
        // $loader->alias('DNS1D', \Milon\Barcode\Facades\DNS1DFacade::class);

        // $loader->alias('Excel', \Maatwebsite\Excel\Facades\Excel::class);
        $loader->alias('flash_messages', \App\Helpers\flash_messages::class);
        $loader->alias('Hashing', \App\Helpers\Hashing::class);
        $loader->alias('Helper', \App\Helpers\Helper::class);


        $file = app_path('Helpers/HelperFunctions.php');
        if (file_exists($file)) {
            require_once($file);
        }
    }
}
