<?php

namespace App\Notifications;

use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CustomResetPassword extends Notification
{
    public $token;
    public $view; // optional view path
    public $guardPrefix; // to help build correct url prefix

    public function __construct($token, $view = null, $guardPrefix = null)
    {
        $this->token = $token;
        $this->view = $view; // e.g. 'emails.owner.reset-password'
        $this->guardPrefix = $guardPrefix; // e.g. 'owner'
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        // Build url with prefix if provided, and include email as query param
        $prefix = $this->guardPrefix ? "/{$this->guardPrefix}" : '';
        $url = url($prefix . '/reset-password/' . $this->token . '?email=' . urlencode($notifiable->email));

        $mail = (new MailMessage)
            ->subject('Reset Your Password')
            ->greeting('Hello ' . ($notifiable->name ?? 'User'))
            ->line('You are receiving this email because we received a password reset request for your account.')
            ->action('Reset Password', $url)
            ->line('If you did not request a password reset, no further action is required.');

        // If custom view provided, use it
        if ($this->view) {
            return $mail->view($this->view, ['url' => $url, 'user' => $notifiable]);
        }

        return $mail;
    }
}
