<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;





use App\Notifications\CustomResetPassword;

class Owner extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

 protected $guard = 'owner' ;


     protected $table = 'users';


    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

      public function user_roles() {
        return $this->hasMany('\App\Models\rbac\UserRole', 'user_id', 'id');
    }
    
    
     public function sendPasswordResetNotification($token)
    {
        // view and prefix optional: view 'emails.owner.reset-password' and prefix 'owner'
        $this->notify(new CustomResetPassword($token, 'emails.owner.reset-password', 'owner'));
    }
}
