<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Queue\SerializesModels;

class ContactUsEmailToAdmin extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The contact form data.
     *
     * @var mixed
     */
    public $row;
    public $request;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($row, $request)
    {
        $this->row = $row;
        $this->request = $request;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        // Corrected syntax to use the Address class with a string for the email.
        // The error was caused by passing an array here.
        return new Envelope(
            from: new Address('no-reply@atulyascaffolding.com', 'Your Application'),
            subject: 'New Contact Us Enquiry Received',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'common.templates.emails.contact_us_email_to_admin',
            with: [
                'row' => $this->row,
                'request' => $this->request,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}