<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactUsAdminMail extends Mailable
{
    use Queueable, SerializesModels;

    public $row;

    /**
     * Create a new message instance.
     */
    public function __construct($row)
    {
        $this->row = $row;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->from(env('MAIL_FROM_ADDRESS', 'no-reply@atulyascaffolding.com'))
                    ->subject('New Contact Us Enquiry Received')
                    ->view('common.templates.emails.contact_us_email_to_admin')
                    ->with([
                        'row' => $this->row
                    ]);
    }
}
