<?php
    
namespace App\Http\Controllers\owner\rbac;

use Illuminate\Session\Store;
use App\Http\Controllers\owner\OwnerBaseController ;

use Illuminate\Http\Request;


use App\Models\rbac\RoleGroup;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages ;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use View;


  
class RoleGroupController extends OwnerBaseController
{
    

    public function __construct(Store $session){
        parent::__construct($session);
      
    }

    public function role_groups(Request $request) {
        //dd($request->all());
        $owner = RoleGroup::findorfail($request->owner_id);
        //dd($owner);
        $owner->syncRoleGroups($request->role_groups);
        return redirect('owner/role_group')->with('success', 'RoleGroups added successfully!');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {

        return view('owner.rbac.role_group.index');
    }

      public function role_group_grid(Request $req) {        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');        
           
        $search_coloumns = ['rg_name','id','rg_code'];
            if(!empty($search_term)){
                $rows = RoleGroup::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                           $q->orWhere($field, 'like', "%{$search_term}%");
                })->where('id', '>=', 1)->paginate($limit);
            }else{
                $rows = RoleGroup::where('id', '>=', 1)->paginate($limit); 
             }
    //dd($rows);
        return view('owner.rbac.role_group.role_group_grid',['result_data'=>$rows]);
    }  
    

   public function role_group_down($all_role_group_array, $currentid, $parentfound = false, $role_groups = array()){
    foreach($all_role_group_array as $row){
        if((!$parentfound && $row['id'] == $currentid) || $row['parent_id'] == $currentid  ){
            $rowdata = array();
            foreach($row as $k => $v)
                $rowdata[$k] = $v;
            $role_groups[] = $rowdata;
            if($row['parent_id'] == $currentid )
                $role_groups = array_merge($role_groups, $this->role_group_down($all_role_group_array, $row['id'], true));
        }
    }
    
    return $role_groups;
}
    

    
   public function role_group_down_ids($data_from_role_group_down = array()){
       if(!empty($data_from_role_group_down)){
           $role_group_down_ids = array();
            foreach($data_from_role_group_down as $row){
                array_push($role_group_down_ids,$row['id']);
            }
       }
    return $role_group_down_ids;
}
   

public function role_group_up_ids($all_role_group_array = array(),$role_group_down_ids){
       if(!empty($all_role_group_array)){
           $role_group_up_ids = array();
            foreach($all_role_group_array as $row){
                if( !in_array($row['id'], $role_group_down_ids))
                array_push($role_group_up_ids,$row['id']);
            }
       }
    return $role_group_up_ids;
}
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       // dd( Auth::guard('owner')->user()->role_group);
        $role_groups = RoleGroup::all();
        
       
        
        $user_role_group = RoleGroup::where('rg_code', Auth::guard('owner')->user()->role_group)->first();
      
            $scr_array = $role_groups->toArray();
            $currentid = $user_role_group->id;
            $current_parent = $user_role_group->parent_id;

           // $role_group_down = $this->role_group_up($scr_array,$current_parent);
            
            $role_group_down = $this->role_group_down($scr_array,$currentid);
            
            $role_group_down_ids = $this->role_group_down_ids($role_group_down);
            
            $role_group_up_ids = $this->role_group_up_ids($scr_array,$role_group_down_ids);
             // dd($role_group_down);
             //  dd($role_group_up_ids);
                        

        
       
        
       
      //  $role_groups = RoleGroup::all();
    
        return view('owner.rbac.role_group.create',[
            'role_groups'=>$role_groups,
            'role_group_down_ids'=>$role_group_down_ids,
            'role_group_up_ids'=>$role_group_up_ids,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
            'name' => ['required', 'string', 'min:2','max:100'],
            'code' => ['required', 'string', 'min:2', 'max:128'],
            'rg_parent' => ['required', 'integer'],
            'status' => ['required', 'integer'],
         
        ]);


        //dd($v->errors());
       if ($v->fails()) {
            if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
        
        }
        $rg_code = slugify_underscore($data['code']);
          $check_role_group = $this->check_unique_role_group($rg_code,$id=0);    
        if(!empty($check_role_group->rg_code)){
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_role_group['status']];
            
            
              if($request->ajax()){
             flash_messages::add_message('e', 'This RoleGroup Group already exists and in '.$state.' State. Kindly contact change role_group code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This RoleGroup Group already exists and in '.$state.' State. Kindly contact change role_group code');
            
      
            
           // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }     
        
       
      
        
        
        $role_group = new RoleGroup();
        $role_group->rg_name = $request->name;
        $role_group->parent_id = $request->rg_parent;
        $role_group->rg_code = slugify_underscore($request->code);
        
      
       $role_group->rg_description = $request->rg_description;
       $role_group->status = $request->status;
    
        $role_group->save();

       
        if ($role_group->id) {           
             if($request->ajax()){
             flash_messages::add_message('s', 'RoleGroup added successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect('owner/employee')->with('success','RoleGroup added successfully!');           
        } else {
            
              if($request->ajax()){
             flash_messages::add_message('e', 'Unable to add RoleGroup. Please try again!');
            return flash_messages::display_message(true);
            }   
           return redirect()->back()->with('error','Unable to add RoleGroup. Please try again!');       
        }


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
    
         $row = RoleGroup::findOrFail($id);

   
        return view('owner.role_group.show', [
            'row' => $row, 
       //     'RoleGroup' => $RoleGroup, 
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
      
        $row = RoleGroup::findOrFail($id);
 $role_groups = RoleGroup::all();
 
  $user_role_group = RoleGroup::where('rg_code', Auth::guard('owner')->user()->role_group)->first();
      
            $scr_array = $role_groups->toArray();
            $currentid = $user_role_group->id;
            $current_parent = $user_role_group->parent_id;

           // $role_group_down = $this->role_group_up($scr_array,$current_parent);
            
            $role_group_down = $this->role_group_down($scr_array,$currentid);
            
            $role_group_down_ids = $this->role_group_down_ids($role_group_down);
            
            $role_group_up_ids = $this->role_group_up_ids($scr_array,$role_group_down_ids);
 
 
        return view('owner.rbac.role_group.edit', [
            'row' => $row, 
            'role_groups'=>$role_groups,
            'role_group_down_ids'=>$role_group_down_ids,
            'role_group_up_ids'=>$role_group_up_ids,
           
        ]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /*$owner = RoleGroup::find($id);*/

       $v = Validator::make($data, [
            'name' => ['required', 'string', 'min:2','max:100'],
           // 'code' => ['required', 'string', 'min:2','max:100'],
            'status' => ['required', 'integer'],
              
        ]);


        //dd($v->errors());
        if ($v->fails()) {
             if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
             
         //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        
              $rg_code = slugify_underscore($data['code']);
          $check_role_group = $this->check_unique_role_group($rg_code,$id);    
        if(!empty($check_role_group->rg_code)){
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_role_group['status']];
            
                if($request->ajax()){
             flash_messages::add_message('e', 'This role_group already exists and in '.$state.' State. Kindly contact change role_group code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This role_group already exists and in '.$state.' State. Kindly contact change role_group code');
            
           // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }     
        
        
        $check = RoleGroup::findorfail($id);
        //$owner->assignRoleGroup($request->role_group);



           $save =  RoleGroup::where('id', $id)->update([
            'rg_name'  => $data['name'],
           // 'r_code'  => slugify_underscore($data['code']),
            'rg_description'  => $data['description'],
            'parent_id'  => $data['rg_parent'],
            'status'  => $data['status'],
            
        ]);

            if($request->ajax()){
             flash_messages::add_message('s', 'Updated successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('success','Updated successfully!');
       // return redirect()->back()->with('success', 'Data updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        $row = RoleGroup::where('id', $id)->first();
        if($row->role_group == 'owner') {
            return redirect('owner/role_group')->with('error', 'Admin owners can not be deleted');
        }
        $row->status = '2';
        $row->delete();
        return redirect('owner/role_group')->with('success', 'RoleGroup deleted successfully!');
    }


    public function check_unique_role_group($rg_code,$id=0) {
        $row = RoleGroup::where('rg_code', $rg_code)->where('id',"!=" ,$id)->first();
        return $row;
    }
    
    
 
}