<?php

namespace App\Http\Controllers\superadmin\rbac;

use Illuminate\Session\Store;
use App\Http\Controllers\superadmin\SuperAdminBaseController;
use Illuminate\Http\Request;
use App\Models\superadmin\rbac\Permission;
use App\Models\superadmin\rbac\Module;
use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;

class PermissionController extends SuperAdminBaseController {

     public function __construct(Store $session){
        parent::__construct($session);
    }

    public function permissions(Request $request) {
        //dd($request->all());
        $superadmin = Permission::findorfail($request->superadmin_id);
        //dd($superadmin);
        $superadmin->syncPermissions($request->permissions);
        return redirect('superadmin/permission')->with('success', 'Permissions added successfully!');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {

        return view('superadmin.rbac.permission.index');
    }

    public function permission_grid(Request $req) {
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');

        $search_coloumns = ['p_name', 'id', 'p_code'];
        if (!empty($search_term)) {
            $rows = Permission::with('module')->where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)->paginate($limit);
        } else {
            $rows = Permission::with('module')->where('id', '>=', 1)->paginate($limit);
        }

        return view('superadmin.rbac.permission.permission_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        $modules = Module::where('status', '=', 1)->get();
        return view('superadmin.rbac.permission.create', [
            'modules' => $modules,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    'code' => ['required', 'string', 'min:2', 'max:128'],
                    'status' => ['required', 'integer'],
                    'module' => ['required', 'integer'],
        ]);


        //dd($v->errors());
       if ($v->fails()) {
            if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
        
        }

        $p_code = slugify_underscore($data['code']);
        $check_permission = $this->check_unique_permission($p_code, $id = 0);
        if (!empty($check_permission->p_code)) {
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_permission['status']];

              if($request->ajax()){
             flash_messages::add_message('e', 'This permission already exists and in ' . $state . ' State. Kindly contact change permission code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This permission already exists and in ' . $state . ' State. Kindly contact change permission code');
            
            
     

            // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }





        $permission = new Permission();
        $permission->p_name = $request->name;
        $permission->p_code = slugify_underscore($request->code);
        $permission->module_id_fk = $request->module;
        $permission->status = $request->status;

        $permission->save();


         
        if ($permission->id) {           
             if($request->ajax()){
             flash_messages::add_message('s', 'Permission added successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect('superadmin/employee')->with('success','Permission added successfully!');           
        } else {
            
              if($request->ajax()){
             flash_messages::add_message('e', 'Unable to add Permission. Please try again!');
            return flash_messages::display_message(true);
            }   
           return redirect()->back()->with('error','Unable to add Permission. Please try again!');       
        }

        
    
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {

        $row = Permission::findOrFail($id);


        return view('superadmin.permission.show', [
            'row' => $row,
                //     'Permission' => $Permission, 
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {

        $row = Permission::findOrFail($id);
        $modules = Module::where('status', '=', 1)->get();

        return view('superadmin.rbac.permission.edit', [
            'row' => $row,
            'modules' => $modules,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $superadmin = Permission::find($id); */

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    // 'code' => ['required', 'string', 'min:2','max:100'],
                    'status' => ['required', 'integer'],
                    'module' => ['required', 'integer'],
        ]);


        //dd($v->errors());
        if ($v->fails()) {
         if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
        
      
        }


        $p_code = slugify_underscore($data['code']);
        $check_permission = $this->check_unique_permission($p_code, $id);
        if (!empty($check_permission->p_code)) {
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_permission['status']];

        if($request->ajax()){
             flash_messages::add_message('e', 'This permission already exists and in ' . $state . ' State. Kindly contact change permission code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This permission already exists and in ' . $state . ' State. Kindly contact change permission code');
            
            
     
            // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }


        $check = Permission::findorfail($id);
        //$superadmin->assignPermission($request->permission);



        $save = Permission::where('id', $id)->update([
            'p_name' => $data['name'],
            //  'p_code'  => slugify_underscore($data['code']),
            'module_id_fk' => $data['module'],
            'status' => $data['status'],
        ]);

        if($request->ajax()){
             flash_messages::add_message('s', 'Updated successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('success','Updated successfully!');


        // return redirect()->back()->with('success', 'Data updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        $row = Permission::where('id', $id)->first();
        if ($row->permission == 'superadmin') {
            return redirect('superadmin/permission')->with('error', 'Admin superadmins can not be deleted');
        }
        $row->status = '2';
        $row->delete();
        return redirect('superadmin/permission')->with('success', 'Permission deleted successfully!');
    }

    public function check_unique_permission($m_code, $id = 0) {
        $row = Permission::where('p_code', $m_code)->where('id', "!=", $id)->first();
        return $row;
    }

}
