<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\Training as Training;

use DB;

use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class TrainingController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_training|view_training');
        return view('owner.training.index');
    }

    public function training_grid(Request $req) {
     //  check_permission('owner_training|view_training');
       
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['title', 'description'];
        if (!empty($search_term)) {
            $rows = Training::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })
                            ->where('id', '>=', 1)
                            ->orderBy('status', 'DESC')
                   
                  
                    ->paginate($limit);
        } else {
            $rows = Training::where('id', '>=', 1)
                    ->orderBy('status', 'DESC')
                 
                 
                    ->paginate($limit);
        }
//dd($rows);
        return view('owner.training.training_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_training|create_training');
        
       $categories = Training::where('status',1)->get();
        return view('owner.training.create', [
          'categories'=>$categories,
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_training|create_training');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'title' => ['required', 'string', 'min:2', 'max:100'],
                 //   'category' => ['required', 'integer'],
          
             'small_description' => ['string', 'min:2', 'max:255'],                   
                   //  'link' => ['string',  'max:255'],         
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'required,image|mimes:jpeg,jpg|max:5120',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

       
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $training = new Training();
        
        $training->title = $request->title;
      
            //  $training->category_id = $request->category;
                $training->small_description = $request->small_description;
              $training->description = $request->description;
            
              $training->video_url = $request->link;
        $training->status = $request->status;
       
        $training->updated_by = $userid;
        $training->updated_at = $current_timestamp;
        $training->created_by = $userid;
        $training->created_at = $current_timestamp;
       
    $training->save();

      

        if ($training->id){
            $training_id = $training->id;
            if ($request->hasFile('training_image')) {
                $file = $request->file('training_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $training_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('training/training_image', $file_name);
                    $training->image = $path;
                    $training->save();
                }
            }
            
          
          
            
            
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Saved successfully!');
        return flash_messages::display_message($request, $url = "owner/training");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Image. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_training|view_training');
        
        $row = Training::findOrFail($id);

      
        return view('owner.training.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_training|edit_training');

        $row = Training::findOrFail($id);
      
     $categories = Training::where('status',1)->get();
        return view('owner.training.edit', [
            'row' => $row,
            'categories' => $categories,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_training|edit_training');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $training = Training::find($id); */

        $v = Validator::make($data, [
                   'title' => ['required', 'string', 'min:2', 'max:100'],
                   // 'category' => ['required', 'integer'],
          
             'small_description' => ['string', 'min:2', 'max:255'],                   
                     //'link' => ['string',  'max:255'],         
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'image|mimes:jpeg,jpg|max:5120',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $training = Training::findorfail($id);
              
               $training->title = $request->title;
      
             // $training->category_id = $request->category;
                $training->small_description = $request->small_description;
              $training->description = $request->description;
            
              $training->video_url = $request->link;
        $training->status = $request->status;
       
        $training->updated_by = $userid;
        $training->updated_at = $current_timestamp;
      //  $training->created_by = $userid;
      //  $training->created_at = $current_timestamp;
       


               $training->save();

               $training_id = $id;

               if ($request->hasFile('training_image')) {
                   $file = $request->file('training_image');
                   $time = time();
                   if ($file->isValid()) {

                       $filename_to_delete = storage_path() . '/app/' . $training->image;
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "img" . "_" . $training_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('training/training_image', $file_name);
                       // dd($path);
                       $training->image = $path;
                       $training->save();
                       // save in database
                   }
               }

               
                   if ($request->hasFile('image_two')) {
                $file = $request->file('image_two');
                $time = time();
                if ($file->isValid()) {
                    
                     $filename_to_delete = storage_path() . '/app/' . $training->image_two;
                     @unlink($filename_to_delete);
                       
                    $ext = strtolower($file->extension());
                    $file_name = "img2" . "_" . $training_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('training/training_image', $file_name);
                    $training->image_two = $path;
                    $training->save();
                }
            }
            
            if ($request->hasFile('image_three')) {
                $file = $request->file('image_three');
                $time = time();
                if ($file->isValid()) {
                     $filename_to_delete = storage_path() . '/app/' . $training->image_three;
                       @unlink($filename_to_delete);
                       
                    $ext = strtolower($file->extension());
                    $file_name = "img3" . "_" . $training_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('training/training_image', $file_name);
                    $training->image_three = $path;
                    $training->save();
                }
            }
            
                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update training details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_training|delete_training');
        
        $row = Training::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/training')->with('success', 'Training deleted successfully!');
    }


}
