<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\TrainingCertificate;

use DB;

use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;


use Illuminate\Support\Facades\Storage;

class TrainingCertificateController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_training_certificate|view_training_certificate');
        return view('owner.training_certificate.index');
    }

    public function training_certificate_grid(Request $req) {
     //  check_permission('owner_training_certificate|view_training_certificate');
       
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name'];
        if (!empty($search_term)) {
            $rows = TrainingCertificate::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                  
                    ->paginate($limit);
        } else {
            
            $rows = TrainingCertificate::where('id', '>=', 1)
                 
                 
                    ->paginate($limit);
        }
//dd($rows);
        return view('owner.training_certificate.training_certificate_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_training_certificate|create_training_certificate');
        
    //   $training_certificates = TrainingCertificate::where('status',1)->get();
        return view('owner.training_certificate.create', [
        //  'training_certificates'=>$training_certificates,
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_training_certificate|create_training_certificate');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],                 
                    'email' => ['required','email', 'string', 'min:2', 'max:100'],                 
                    'mobile' => ['required', 'string', 'min:10', 'max:10'],                 
                   // 'status' => ['required', 'integer', 'max:99'],
                    'file' => 'required|mimes:pdf|max:5120|min:10',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

       

        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $training_certificate = new TrainingCertificate();
        
        $training_certificate->name = $request->name;
        $training_certificate->email = $request->email;
        $training_certificate->mobile = $request->mobile;
        $training_certificate->updated_at = $current_timestamp;
        $training_certificate->updated_by = $userid;
        $training_certificate->created_at = $current_timestamp;
        $training_certificate->created_by = $userid;      
        $training_certificate->status = 0;
      
      $training_certificate->save();

      

        if ($training_certificate->id){
            $training_certificate_id = $training_certificate->id;
            if ($request->hasFile('file')) {
                $file = $request->file('file');
                
                
                $time = time();
                if ($file->isValid()) {
                      $ext = strtolower($file->extension());
                    $file_name = "file" . "_" . $training_certificate_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('training_certificate', $file_name);
                    // Get the extension (guessed by the server based on content)
        //$extension = $file->extension(); 

        // Get the original extension provided by the client
        //$originalExtension = $file->getClientOriginalExtension(); 
                    $training_certificate->path = $path;
                   // $training_certificate->extension = $ext;
                    $training_certificate->save();
                }
            }
            
            
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Saved successfully!');
        return flash_messages::display_message($request, $url = "owner/training_certificate");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add file. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_training_certificate|view_training_certificate');
        
        $row = TrainingCertificate::findOrFail($id);

      
        return view('owner.training_certificate.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_training_certificate|edit_training_certificate');

        $row = TrainingCertificate::findOrFail($id);
      
     $training_certificates = TrainingCertificate::where('status',1)->get();
        return view('owner.training_certificate.edit', [
            'row' => $row,
            'training_certificates' => $training_certificates,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_training_certificate|edit_training_certificate');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $training_certificate = TrainingCertificate::find($id); */

        $v = Validator::make($data, [
                      'name' => ['required', 'string', 'min:2', 'max:100'],                 
                    'email' => ['required','email', 'string', 'min:2', 'max:100'],                 
                    'mobile' => ['required', 'string', 'min:10', 'max:10'],                 
                   // 'status' => ['required', 'integer', 'max:99'],
                    'file' => 'mimes:pdf|max:5120|min:10',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $training_certificate = TrainingCertificate::findorfail($id);
               //$training_certificate->assignRole($request->role);
                 $training_certificate->name = $request->name;
                $training_certificate->email = $request->email;
                $training_certificate->mobile = $request->mobile;
                $training_certificate->updated_at = $current_timestamp;
                $training_certificate->updated_by = $userid;
                $training_certificate->created_at = $current_timestamp;
                $training_certificate->created_by = $userid;      
                //$training_certificate->status = 0;
                
              $training_certificate->save();

               $training_certificate_id = $id;               
                
               if ($request->hasFile('file')) {
                   $file = $request->file('file');
                   $time = time();
                   if ($file->isValid()) {
//                        $filename_to_delete = storage_path() . '/app/private/' . $training_certificate->image;
//  dd($filename_to_delete);
                       $filename_to_delete = storage_path() . '/app/private/' . $training_certificate->path;
                     
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "file" . "_" . $training_certificate_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('training_certificate', $file_name);
                       // dd($path);
                       $training_certificate->path = $path;
                    //   $training_certificate->extension = $ext;
                       $training_certificate->save();
                       // save in database
                   }
               }

                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
    }
    
    
     public function download($path=''){
       //  dd('afafafafaf0');
      //  $path = 'training_certificates/' . $filename; // Assuming files are in 'storage/app/public/training_certificates'
 
        if($path != "" && Storage::exists($path)) {
      //  dd('trueeeeeee');
       // return url('storage/app/private/' . $path);
         return Storage::download($path);
    }
//        if (Storage::disk('public')->exists($path)) {
//            return Storage::disk('public')->download($path, $filename);
//        }

        return back()->with('error', 'File not found.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_training_certificate|delete_training_certificate');
        
        $row = TrainingCertificate::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/training_certificate')->with('success', 'TrainingCertificate deleted successfully!');
    }


}
