<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\Team as Team;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class TeamController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_team|view_team');
        return view('owner.team.index');
    }

    public function team_grid(Request $req) {
     //  check_permission('owner_team|view_team');
        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name', 'id', 'email'];
        if (!empty($search_term)) {
            $rows = Team::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                  
                    ->paginate($limit);
        } else {
            $rows = Team::where('id', '>=', 1)
                 
                 
                    ->paginate($limit);
        }

        return view('owner.team.team_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_team|create_team');
        
       
        return view('owner.team.create', [
          
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_team|create_team');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    'designation' => ['required', 'string', 'min:2', 'max:100'],
                    'message' => ['required', 'string', 'min:10', 'max:1000'],
                    'priority' => ['required', 'integer', 'max:100'],
                    'facebook_link' => [ 'string', 'min:2', 'max:255'],
                    'instagram_link' => [ 'string', 'min:2', 'max:255'],
                    'linkedin_link' => [ 'string', 'min:2', 'max:255'],
                    'twitter_link' => [ 'string', 'min:2', 'max:255'],                  
                    'status' => ['required', 'integer', 'max:99'],
                    'team_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $team = new Team();
        $team->name = $request->name;
        $team->designation = $request->designation;
        $team->message = $request->message;
        $team->priority_order = $request->priority;
        $team->facebook_link = $request->facebook;
        $team->instagram_link = $request->instagram;
        $team->linkedin_link = $request->linkedin;
        $team->twitter_link = $request->twitter;
       $team->status = $request->status;
        $team->updated_by = $userid;
        $team->updated_at = $current_timestamp;
        $team->created_by = $userid;
        $team->created_at = $current_timestamp;
       
        $team->save();

      

        if ($team->id) {
            $team_id = $team->id;
            
            if ($request->hasFile('team_image')) {
                $file = $request->file('team_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $team_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('team/team_image', $file_name);
                    $team->image = $path;
                    $team->save();
                }
            }

           
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Member added successfully!');
        return flash_messages::display_message($request, $url = "owner/team");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Member. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_team|view_team');
        
        $row = Team::findOrFail($id);

      
        return view('owner.team.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_team|edit_team');

        $row = Team::findOrFail($id);
      
     
        return view('owner.team.edit', [
            'row' => $row,
            
          
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_team|edit_team');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $team = Team::find($id); */

        $v = Validator::make($data, [
                      'name' => ['required', 'string', 'min:2', 'max:100'],
                    'designation' => ['required', 'string', 'min:2', 'max:100'],
                    'message' => ['required', 'string', 'min:10', 'max:1000'],
                    'priority' => ['required', 'integer', 'max:100'],
                    'facebook_link' => [ 'string', 'min:2', 'max:255'],
                    'instagram_link' => [ 'string', 'min:2', 'max:255'],
                    'linkedin_link' => [ 'string', 'min:2', 'max:255'],
                    'twitter_link' => [ 'string', 'min:2', 'max:255'],                  
                    'status' => ['required', 'integer', 'max:99'],
                    'team_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $team = Team::findorfail($id);
        
        $team->name = $request->name;
        $team->designation = $request->designation;
        $team->message = $request->message;
        $team->priority_order = $request->priority;
        $team->facebook_link = $request->facebook;
        $team->instagram_link = $request->instagram;
        $team->linkedin_link = $request->linkedin;
        $team->twitter_link = $request->twitter;
        $team->status = $request->status;
       
        $team->updated_by = $userid;
        $team->updated_at = $current_timestamp;
        $team->created_by = $userid;
        $team->created_at = $current_timestamp;
       


               $team->save();

               $team_id = $id;

               if ($request->hasFile('team_image')) {
                   $file = $request->file('team_image');
                   $time = time();
                   if ($file->isValid()) {

                       $filename_to_delete = storage_path() . '/app/' . $team->image;
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "img" . "_" . $team_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('team/team_image', $file_name);
                       // dd($path);
                       $team->image = $path;
                       $team->save();
                       // save in database
                   }
               }

                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update team details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_team|delete_team');
        
        $row = Team::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/team')->with('success', 'Team deleted successfully!');
    }


}
