<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\Owner as Owner;
use App\Models\rbac\Role;
use App\Models\rbac\UserRole;
use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class OwnerController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }

    public function roles(Request $request) {
        //dd($request->all());
        $owner = Owner::findorfail($request->owner_id);
        //dd($owner);
        $owner->syncRoles($request->roles);
        return redirect('owner/owner')->with('success', 'Roles added successfully!');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//
//        $table_name = Owner::getTableName();
//        $Role = Role::all();
//
//        $conditions = array();
//
//        
//       $rows = Owner::whereDoesntHave('roles', function ($query) {
//    $query->where('name','=', 'customer')->orWhere('name','=', 'owner');
//})->where($conditions)->orderBy('id', 'desc')->get();
//        //dd($rows);
//        
//        
       //  dd($this->get_site_setting());

 //check_permission('owner_owner|view_owner');
        return view('owner.owner.index');
    }

    public function owner_grid(Request $req) {
     //  check_permission('owner_owner|view_owner');
        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name', 'id', 'email'];
        if (!empty($search_term)) {
            $rows = Owner::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                    ->where('role_group', '=', 'owners')
                    ->paginate($limit);
        } else {
            $rows = Owner::where('id', '>=', 1)
                 
                    ->where('role_group', '=', 'owners')
                    ->paginate($limit);
        }

        return view('owner.owner.owner_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_owner|create_owner');
        
        $roles = Role::where('rg_code', '=', 'owners')->where('status', '=', 1)->get();
     //   dd($roles);
     $user_role_id = Auth::guard($this->guard_name)->user()->role_id;
        
                $roles = Role::where('status', '=', 1)
                
                
                ->where('belongs_to', '=', 'enterprise')
                
                ->get();
            //    dd($roles);
        $roles_array = $roles->toArray();
     //   dd($roles_array);
        $role_down = $this->role_down($roles_array,$user_role_id,true);
       // dd($role_down);
   //  $role_down_ids = $this->role_down_ids($role_down) ;
       
        return view('owner.owner.create', [
            'roles' => $roles,
           //'role_down_ids' => $role_down_ids,
        ]);
    }

     public function sync_enterprise_user(Request $request,$user_id=0) {
        //  dd($request->post());
//check_permission('enterprise|edit_enterprise');
       
       
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

         
        if($user_id !==0 && !empty($data['enterprise'])){
            $check_existing = EnterpriseUser::where('user_id', '=', $user_id)->get();
                if (!empty($check_existing) && count($check_existing) > 0) {
                   $delete_existing = EnterpriseUser::where('user_id', '=', $user_id)->delete();  
                }
        
            
            $enterprise_user = new EnterpriseUser();            
            $enterprise_user->user_id = $user_id;
            $enterprise_user->enterprise_id = $data['enterprise'];
            $enterprise_user->share = 0;
           $save =  $enterprise_user->save();
           if($save){               
               flash_messages::add_message('s', 'User synced successfully!');
            }else{
                 flash_messages::add_message('e', 'Cannot sync Users!');
            }        
        }
    }  
    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_owner|create_owner');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    'email' => ['required', 'string', 'email', 'max:128'],
                    'mobile' => ['required', 'string', 'min:10', 'max:10'],
                    
                    'role' => ['required','string'],
                    'profile_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        // dd($v->errors()->all());
        $check_email = $this->check_unique_email($data['email'], $id = 0);
        if (!empty($check_email->email)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_email['status']];
        flash_messages::add_message('e', 'This email already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
        
        }

        $check_mobile = $this->check_unique_mobile($data['mobile'], $id = 0);
        if (!empty($check_mobile->mobile)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_mobile['status']];
            
        flash_messages::add_message('e', 'This mobile already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
        }


        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $owner = new Owner();
        $owner->name = $request->name;

        $exploded = explode('|', $request->role);
        $role_group = $exploded[0];
        $role_id = $exploded[1];
        $role_code = $exploded[2];
        
        $owner->role_group = $role_group;
        $owner->role =$role_code;
        $owner->role_id = $role_id;
        $owner->guard = 'owner';
        $owner->email = $request->email;
   
        $owner->address = $request->address;
        $owner->mobile = $request->mobile;
        $owner->password = Hash::make(config('constants.DEFAULT_PASSWORD'));
         $owner->status = $request->status;
        // $owner->email_verified = '1';

        /* if($request->referred_by) {
          $owner->referred_by = $request->referred_by;
          }

          if($request->device) {
          $owner->device = $request->device;
          }

          if($request->device_token) {
          $owner->device_token = $request->device_token;
          } */

        $owner->save();

        $owner_unique_id_length = config('constants.EMPLOYEE_UNIQUE_ID_LENGTH');
        
        $owner_unique_id = 'E' . str_pad($owner->id, $owner_unique_id_length, '0', STR_PAD_LEFT);
        $owner->user_unique_id = $owner_unique_id;

        
//        $referral_code = 'OW' . str_pad($owner->id, getConfigData('REFERRAL_CODE_LENGTH'), '0', STR_PAD_LEFT);
//        $owner->referral_code = $referral_code;

        $owner->save();

        //  $owner->assignRole($request->role);
//        $mobile = $request->mobile;
//       $mobile = "9958038162";
//
//        $sms_message = "Dear " . $request->name . ", Your Positive Images Account is created. You may login to App with your mobile " . $mobile . " and password " . 'jhkhj';
//        $SMS_API_KEY = config('constants.SMS_API_KEY');
//        $sms_url = "https://api.textlocal.in/send/?apiKey=" . $SMS_API_KEY . "&sender=TXTLCL&numbers=91" . $mobile . "&message=" . urlencode($sms_message);
//        file_get_contents($sms_url);
        //exit($sms_url);

        if ($owner->id) {
            $owner_id = $owner->id;
            
     
              
            if ($request->hasFile('profile_image')) {
                $file = $request->file('profile_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $owner_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('owner/profile_image', $file_name);
                    $owner->profile_image = $path;
                    $owner->save();
                }
            }

            if (!empty($request->role)) {
                $user_role = new UserRole();
                $user_role->user_id = $owner_id;
                $user_role->role_id = $role_id;
                $user_role->save();
            }
            
           
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Owner added successfully!');
        return flash_messages::display_message($request, $url = "owner/owner");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Owner. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_owner|view_owner');
        
        $row = Owner::findOrFail($id);

        $roles = Role::where('rg_code', '=', 'owners')->where('status', '=', 1)->get();
     //   dd($roles);
     $user_role_id = Auth::guard($this->guard_name)->user()->role_id;
        
                $roles = Role::where('status', '=', 1)
                
                ->Where('is_default', '=', 1)
                ->orWhere('is_default', '=', 0)
                ->where('belongs_to', '=', 'enterprise')
                
                ->get();
        $roles_array = $roles->toArray();
        $role_down = $this->role_down($roles_array,$user_role_id,true);
     $role_down_ids = $this->role_down_ids($role_down) ;
       
        
        return view('owner.owner.show', [
            'row' => $row,
             'roles' => $roles,
           'role_down_ids' => $role_down_ids,
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_owner|edit_owner');

        $row = Owner::findOrFail($id);
        $roles = Role::where('rg_code', '=', 'owners')->where('status', '=', 1)->get();
     
        return view('owner.owner.edit', [
            'row' => $row,
            'roles' => $roles,
          
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_owner|edit_owner');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $owner = Owner::find($id); */

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    'email' => ['required', 'string', 'email', 'max:128'],
                    'mobile' => ['required', 'string', 'min:10', 'max:10'],
                   
                    'role' => ['required', 'string'],
                    'profile_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }


        $check_email = $this->check_unique_email($data['email'], $id);
        if (!empty($check_email->email)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_email['status']];

              flash_messages::add_message('e', 'This email already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
            
        
            // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }

        $check_mobile = $this->check_unique_mobile($data['mobile'], $id);
        if (!empty($check_mobile->mobile)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_mobile['status']];
            
                flash_messages::add_message('e','This mobile already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
            
         
        }

        
        
       
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard('owner')->user()->id;
    //  dd($userid);

        
        
   $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');

        $owner = Owner::findorfail($id);
        //$owner->assignRole($request->role);

        $owner->name = $request->name;
       
        $owner->email = $request->email;

        $owner->mobile = $request->mobile;
        
        $exploded = explode('|', $request->role);
        $role_group = $exploded[0];
        $role_id = $exploded[1];
        $role_code = $exploded[2];

        $owner->role_group = $role_group;
        $owner->role = $role_code;
        $owner->role_id = $role_id;
       // $owner->guard = 'owner';
        $owner->address = $request->address;
        $owner->status = $request->status;
       
        $owner->email_verified = '1';
        $owner->email_verified_at= $current_timestamp;

 

        $owner->save();

        $owner_id = $id;

        
        
//            $owner_details = OwnerDetail::where('owner_id',$owner_id)->first();
//         
//            $owner_details->address = $request->address;
//             $owner_details->name = $request->name;
//          //  $owner_details->owner_id = $owner_id;
//             $owner_details->gst_number = $request->gst_number;
//        
//        $owner_details->save();
        
        
        
        if ($request->hasFile('profile_image')) {
            $file = $request->file('profile_image');
            $time = time();
            if ($file->isValid()) {

                $filename_to_delete = storage_path() . '/app/' . $owner->profile_image;
                @unlink($filename_to_delete);

                $ext = strtolower($file->extension());
                $file_name = "img" . "_" . $owner_id . "_" . $time . "." . $ext;
                $path = $file->storeAs('owner/profile_image', $file_name);
                // dd($path);
                $owner->profile_image = $path;
                $owner->save();
                // save in database
            }
        }

        
              if (!empty($request->role)) {
                $user_role = UserRole::where('user_id','=',$owner_id)->first();
                if(empty($user_role)){
                    $user_role = new UserRole(); 
                }
                $user_role->user_id = $owner_id;
                $user_role->role_id = $role_id;
                $user_role->save();
            }
            
        
        
                if (!empty($request->enterprise)) {               
      
                   $this->sync_enterprise_user($request,$owner_id);
                }
        
        
        

            // return redirect()->back()->with('success', 'Data updated successfully!');
      
                DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                flash_messages::add_message('s','Updated successfully!');
                return flash_messages::display_message($request, $url = "back");
            
         
            
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
            flash_messages::add_message('e', 'Unable to update owner details. Please try again!'.$exp);
            return flash_messages::display_message($request, $url = "back");   
           
        }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_owner|delete_owner');
        
        $row = Owner::where('id', $id)->first();
        if ($row->role == 'owner' || $row->role == 'superadmin') {
            return redirect('owner/owner')->with('error', 'This can not be deleted');
        }
        $row->status = '2';
        $row->save();
        return redirect('owner/owner')->with('success', 'Owner deleted successfully!');
    }

    public function check_unique_email($email, $id = 0) {
     //  check_permission('owner_owner|view_owner');
        
        $row = Owner::where('email', $email)->where('id', "!=", $id)->first();
        return $row;
    }

    public function check_unique_mobile($mobile, $id = 0) {
      // check_permission('owner_owner|view_owner');
        
        $row = Owner::where('mobile', $mobile)->where('id', "!=", $id)->first();
        return $row;
    }

    public function profile() {
        
        $id = Auth::guard($this->guard_name)->user()->id;
        $row = Owner::findOrFail($id);

        return view('owner.owner.profile', [
            'row' => $row,
        ]);
    }

    public function change_password() {
      // check_permission('owner_owner|view_owner');
        
        if (empty(Auth::guard($this->guard_name)->user()->id)) {
            return redirect('owner/login');
        }
        return view('owner.owner.change_password');
    }

    public function change_password_submit(Request $request) {
        if (empty(Auth::guard($this->guard_name)->user()->id)) {
            return redirect('owner/login');
        }
        $id = Auth::guard($this->guard_name)->user()->id;
        $email = Auth::guard($this->guard_name)->user()->email;
        $name = Auth::guard($this->guard_name)->user()->name;
        $current_password = $request->current_password;
        $db_current_password = Auth::guard($this->guard_name)->user()->password;

        // dd($hashed_current_password);
        $new_password = Hash::make($request->new_password);
        $pass = password_verify($request->new_password, $db_current_password);
//dd($current_password);
        if ($request->new_password != $request->confirm_password) {
            
               flash_messages::add_message('e', 'Confirm password does not match!');
        return flash_messages::display_message($request, $url = "back");
          //  return redirect()->back()->with('error', 'Confirm password does not match!');
        } elseif ($pass == 1) {
            
              flash_messages::add_message('e', 'New password cannot be same as Old password!');
        return flash_messages::display_message($request, $url = "back");
       //     return redirect()->back()->with('error', 'New password cannot be same as Old password!');
        } elseif (Hash::check($current_password, $db_current_password)) {
            Owner::where('id', $id)->update(['password' => $new_password]);
            
              flash_messages::add_message('s', 'Password updated successfully!');
        return flash_messages::display_message($request, $url = "back");
        //    return redirect()->back()->with('success', 'Password updated successfully!');
        } else {
            
              flash_messages::add_message('e', 'Old Password entered was invalid!');
        return flash_messages::display_message($request, $url = "back");
          //  return redirect()->back()->with('error', 'Old Password entered was invalid!');
        }
    }

    public function owner_role_grid(Request $req) {

        //  dd($req->id);
        $owner_id = $req->id;
        $roles = Role::where('status', '=', 1)->get();
        $owner_roles = UserRole::where('user_id', '=', $owner_id)->get();
        // dd($owner_roles);
        $existing_role_array = array();
        if (!empty($owner_roles) && count($owner_roles) > 0) {
            //  dd($module_role_permissions); 
            $existing_role_array = array();
            foreach ($owner_roles as $owner_role) {
                array_push($existing_role_array, $owner_role->role_id);
            }
        }
        // dd($existing_role_array) ;
        return view('owner.owner.owner_role_grid', [
            'roles' => $roles,
            'existing_role_array' => $existing_role_array,
            'user_id' => $owner_id,
        ]);
    }

    public function sync_role(Request $request) {
        //  dd($request->post());

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $owner = Permission::find($id); */

        $v = Validator::make($data, [
                    // 'roles' => ['required'],          
                    'user_id' => ['required', 'integer'],
        ]);


        //dd($v->errors());
        if ($v->fails()) {
//             flash_messages::add_message('e',$v->errors()->all());
//            return flash_messages::display_message(true);          
            return redirect()->back()->withErrors($v)->withInput($data);
        }

        $owner_id = $data['user_id'];


        if (!empty($data['roles']) && count($data['roles']) > 0) {
            $roles = $data['roles'];
            $delete_existing = UserRole::where('user_id', '=', $owner_id)->delete();

            $insert_data = array();
            foreach ($roles as $role) {

                $insert_one = array('user_id' => $owner_id, 'role_id' => $role);
                array_push($insert_data, $insert_one);
            }

            $save = UserRole::insert($insert_data);
            // dd($save);
            if ($save) {
                return redirect()->back()->withSuccess('Roles synced successfully');
            } else {
                return redirect()->back()->withErrors('Cannot sync Roles')->withInput($data);
            }
        } else {
            $check_existing = UserRole::where('user_id', '=', $owner_id)->get();
            if (!empty($check_existing) && count($check_existing) > 0) {
                $delete_existing = UserRole::where('user_id', '=', $owner_id)->delete();
                return redirect()->back()->withSuccess('Roles synced successfully')->withInput($data);
            } else {
                return redirect()->back()->withErrors('Cannot sync Roles')->withInput($data);
            }
        }
    }

    
        public function reset_password_to_default(Request $request,$id=0) {
        //dd($id);
         $row = Owner::findOrFail($id);
         
        
        
     
          
             $row->password = Hash::make(config('constants.DEFAULT_PASSWORD'));
             $saved = $row->save();
             if($saved == true){
                     flash_messages::add_message('s', 'Password reset to default');
                    return flash_messages::display_message($request, $url = "owner/owner"); 
                    
                     //return redirect('owner/owner')->with('success','Password reset to default');
             }else{
                  flash_messages::add_message('e', 'Password reset failed');
            return flash_messages::display_message($request, $url = "owner/owner");   
            
               //  return redirect('owner/owner')->with('error','Password reset failed'); 
             }
       
        
      //  return redirect('owner/owner')->with('success','Password Reset to Default');
            
        return view('owner.owner.index');
    }
}
