<?php

namespace App\Http\Controllers\owner;

use App\Http\Controllers\Controller ;

use App\Models\SiteSetting;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Session;
use Illuminate\Session\Store;

use App\Models\School;
use App\Models\Batch;
use App\Models\SchoolOwner;
use App\Models\rbac\Role;



class OwnerBaseController extends Controller
{
   
      
  protected $session;
  protected $guard_name ="owner";

    public function __construct(Store $session){
          parent::__construct();
     //  dd('asdsadasd');
          // Use middleware to delay session-dependent logic
        $this->middleware(function ($request, $next) {
        View::share('site_setting',$this->get_site_setting()); 
            View::share('guard_name',$this->guard_name);
            return $next($request);
        });
    }    

  
    public function get_site_setting(){
        $site_setting = SiteSetting::first();
        return $site_setting;
    }

    
    public function get_role_tree($parent_id = 0, $cat_level = -1, $filter = array(),$school_id=0) {
        $roles = array();
        //$res = Role::all()->where('parent_id', '=', $parent_id)->where('active', '=', '1');
        $conditions = array();
        $conditions[] = [ 'status', '=', '1' ];
        $conditions[] = [ 'parent_id', '=', $parent_id ];
     //   $conditions[] = [ 'school_id', '=', 0 ];
        if(count($filter) > 0) {
            foreach ($filter as $key => $value) {
                $conditions[] = [ $key, '=', $value ];
            }
        }
        

        //dd($conditions);
        $res = Role::with('children')
               // ->where($conditions)
                ->where('parent_id','=',$parent_id)                 
                ->where('belongs_to','=','school')                 
                 ->where('is_default','=',1)
                 ->where('status','=',1)
                ->where(function($q) use($school_id) {                      
                       $q->Where('school_id','=',0)
                            ->orWhere('school_id','=',$school_id);
                    })
//                
                ->orderBy('id', 'asc')->get();
        $loop = 0;
        $cat_level++;

        foreach ($res as $row) {
            $role = array();
            $role['id'] = $row->id;
            $role['parent_id'] = $row->parent_id;
            $role['r_name'] = $row->r_name;
            $role['r_code'] = $row->r_code;
            $role['level'] = $cat_level;
          //  $role['parent_names'] = $row->getParentsNames();
            $role['children'] = $this->get_role_tree($role['id'],$cat_level, $filter,$school_id);
            //$roles[$row['id']] = $role;
            $roles[$loop] = $role;
            $loop++;
        }
        //dd($roles);
        return $roles;
    } // end function get_role_tree()  
     
   
    public function role_down($all_role_array, $currentid, $parentfound = false, $roles = array()){
    foreach($all_role_array as $row){
        if((!$parentfound && $row['id'] == $currentid) || $row['parent_id'] == $currentid  ){
            $rowdata = array();
            foreach($row as $k => $v)
                $rowdata[$k] = $v;
            $roles[] = $rowdata;
            if($row['parent_id'] == $currentid )
                $roles = array_merge($roles, $this->role_down($all_role_array, $row['id'], true));
        }
    }
    
    return $roles;
}   
 

 public function role_down_ids($data_from_role_down = array()){
       if(!empty($data_from_role_down)){
           $role_down_ids = array();
            foreach($data_from_role_down as $row){
                array_push($role_down_ids,$row['id']);
            }
       }
    return $role_down_ids;
}
   

 public function role_group_down($all_role_group_array, $currentid, $parentfound = false, $role_groups = array()){
    foreach($all_role_group_array as $row){
        if((!$parentfound && $row['id'] == $currentid) || $row['parent_id'] == $currentid  ){
            $rowdata = array();
            foreach($row as $k => $v)
                $rowdata[$k] = $v;
            $role_groups[] = $rowdata;
            if($row['parent_id'] == $currentid )
                $role_groups = array_merge($role_groups, $this->role_group_down($all_role_group_array, $row['id'], true));
        }
    }
    
    return $role_groups;
}


 
   public function role_group_down_ids($data_from_role_group_down = array()){
       if(!empty($data_from_role_group_down)){
           $role_group_down_ids = array();
            foreach($data_from_role_group_down as $row){
                array_push($role_group_down_ids,$row['id']);
            }
       }
    return $role_group_down_ids;
}
   
    
   
}
