<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\Gallery as Gallery;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class GalleryController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_gallery|view_gallery');
        return view('owner.gallery.index');
    }

    public function gallery_grid(Request $req) {
     //  check_permission('owner_gallery|view_gallery');
        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name', 'id', 'email'];
        if (!empty($search_term)) {
            $rows = Gallery::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                  
                    ->paginate($limit);
        } else {
            $rows = Gallery::where('id', '>=', 1)
                 
                 
                    ->paginate($limit);
        }

        return view('owner.gallery.gallery_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_gallery|create_gallery');
        
       
        return view('owner.gallery.create', [
          
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_gallery|create_gallery');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'title' => ['required', 'string', 'min:2', 'max:100'],
                  
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

       

        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $gallery = new Gallery();
        $gallery->title = $request->title;
        $gallery->status = $request->status;
       
        $gallery->updated_by = $userid;
        $gallery->updated_at = $current_timestamp;
        $gallery->created_by = $userid;
        $gallery->created_at = $current_timestamp;
       
        $gallery->save();

      

        if ($gallery->id) {
            $gallery_id = $gallery->id;
            
            if ($request->hasFile('gallery_image')) {
                $file = $request->file('gallery_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $gallery_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('gallery/gallery_image', $file_name);
                    $gallery->image = $path;
                    $gallery->save();
                }
            }

           
            
           
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Image added successfully!');
        return flash_messages::display_message($request, $url = "owner/gallery");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Image. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_gallery|view_gallery');
        
        $row = Gallery::findOrFail($id);

      
        return view('owner.gallery.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_gallery|edit_gallery');

        $row = Gallery::findOrFail($id);
      
     
        return view('owner.gallery.edit', [
            'row' => $row,
            
          
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_gallery|edit_gallery');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $gallery = Gallery::find($id); */

        $v = Validator::make($data, [
                     'title' => ['required', 'string', 'min:2', 'max:100'],
                   
                    'status' => ['required', 'integer', 'max:99'],
                    'image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $gallery = Gallery::findorfail($id);
               //$gallery->assignRole($request->role);
           $gallery->title = $request->title;
             
               $gallery->status = $request->status;
               $gallery->updated_by = $userid;
               $gallery->updated_at = $current_timestamp;
               $gallery->created_by = $userid;
               $gallery->created_at = $current_timestamp;


               $gallery->save();

               $gallery_id = $id;

               if ($request->hasFile('gallery_image')) {
                   $file = $request->file('gallery_image');
                   $time = time();
                   if ($file->isValid()) {

                       $filename_to_delete = storage_path() . '/app/' . $gallery->image;
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "img" . "_" . $gallery_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('gallery/gallery_image', $file_name);
                       // dd($path);
                       $gallery->image = $path;
                       $gallery->save();
                       // save in database
                   }
               }

                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update gallery details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_gallery|delete_gallery');
        
        $row = Gallery::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/gallery')->with('success', 'Gallery deleted successfully!');
    }


}
