<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\Employee as Employee;
use App\Models\rbac\Role;
use App\Models\rbac\UserRole;
use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class EmployeeController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }

    public function roles(Request $request) {
        //dd($request->all());
        $employee = Employee::findorfail($request->employee_id);
        //dd($employee);
        $employee->syncRoles($request->roles);
        return redirect('owner/owner')->with('success', 'Roles added successfully!');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//
//        $table_name = Employee::getTableName();
//        $Role = Role::all();
//
//        $conditions = array();
//
//        
//       $rows = Employee::whereDoesntHave('roles', function ($query) {
//    $query->where('name','=', 'customer')->orWhere('name','=', 'employee');
//})->where($conditions)->orderBy('id', 'desc')->get();
//        //dd($rows);
//        
//        
       //  dd($this->get_site_setting());

 //check_permission('owner_employee|view_employee');
        return view('owner.employee.index');
    }

    public function employee_grid(Request $req) {
     //  check_permission('owner_employee|view_employee');
        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name', 'id', 'email'];
        if (!empty($search_term)) {
            $rows = Employee::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                    ->where('role_group', '=', 'employees')
                    ->paginate($limit);
        } else {
            $rows = Employee::where('id', '>=', 1)
                 
                    ->where('role_group', '=', 'employees')
                    ->paginate($limit);
        }

        return view('owner.employee.employee_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
       //check_permission('owner_employee|create_employee');
        
        $roles = Role::where('rg_code', '=', 'employees')->where('status', '=', 1)->get();
     //   dd($roles);
     $user_role_id = Auth::guard($this->guard_name)->user()->role_id;
        
                $roles = Role::where('status', '=', 1)
                
                ->Where('is_default', '=', 1)
                ->orWhere('is_default', '=', 0)
                ->where('belongs_to', '=', 'enterprise')
                
                ->get();
        $roles_array = $roles->toArray();
        $role_down = $this->role_down($roles_array,$user_role_id,true);
     $role_down_ids = $this->role_down_ids($role_down) ;
       
        return view('owner.employee.create', [
            'roles' => $roles,
           'role_down_ids' => $role_down_ids,
        ]);
    }

     public function sync_enterprise_user(Request $request,$user_id=0) {
        //  dd($request->post());
//check_permission('enterprise|edit_enterprise');
       
       
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

         
        if($user_id !==0 && !empty($data['enterprise'])){
            $check_existing = EnterpriseUser::where('user_id', '=', $user_id)->get();
                if (!empty($check_existing) && count($check_existing) > 0) {
                   $delete_existing = EnterpriseUser::where('user_id', '=', $user_id)->delete();  
                }
        
            
            $enterprise_user = new EnterpriseUser();            
            $enterprise_user->user_id = $user_id;
            $enterprise_user->enterprise_id = $data['enterprise'];
            $enterprise_user->share = 0;
           $save =  $enterprise_user->save();
           if($save){               
               flash_messages::add_message('s', 'User synced successfully!');
            }else{
                 flash_messages::add_message('e', 'Cannot sync Users!');
            }        
        }
    }  
    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_employee|create_employee');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    'email' => ['required', 'string', 'email', 'max:128'],
                    'mobile' => ['required', 'string', 'min:10', 'max:10'],
                    
                    'role' => ['required','string'],
                    'profile_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
            
           flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        // dd($v->errors()->all());
        $check_email = $this->check_unique_email($data['email'], $id = 0);
        if (!empty($check_email->email)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_email['status']];
        flash_messages::add_message('e', 'This email already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
        
        }

        $check_mobile = $this->check_unique_mobile($data['mobile'], $id = 0);
        if (!empty($check_mobile->mobile)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_mobile['status']];
            
        flash_messages::add_message('e', 'This mobile already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
        }


        
        
        
        
        
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard($this->guard_name)->user()->id;
    //  dd($userid);

        

        $employee = new Employee();
        $employee->name = $request->name;

        $exploded = explode('|', $request->role);
        $role_group = $exploded[0];
        $role_id = $exploded[1];
        $role_code = $exploded[2];
        
        $employee->role_group = $role_group;
        $employee->role =$role_code;
        $employee->role_id = $role_id;
        $employee->guard = 'employee';
        $employee->email = $request->email;
   
        $employee->address = $request->address;
        $employee->mobile = $request->mobile;
        $employee->password = Hash::make(config('constants.DEFAULT_PASSWORD'));
         $employee->status = $request->status;
        // $employee->email_verified = '1';

        /* if($request->referred_by) {
          $employee->referred_by = $request->referred_by;
          }

          if($request->device) {
          $employee->device = $request->device;
          }

          if($request->device_token) {
          $employee->device_token = $request->device_token;
          } */

        $employee->save();

        $employee_unique_id_length = config('constants.EMPLOYEE_UNIQUE_ID_LENGTH');
        
        $employee_unique_id = 'E' . str_pad($employee->id, $employee_unique_id_length, '0', STR_PAD_LEFT);
        $employee->user_unique_id = $employee_unique_id;

        
//        $referral_code = 'OW' . str_pad($employee->id, getConfigData('REFERRAL_CODE_LENGTH'), '0', STR_PAD_LEFT);
//        $employee->referral_code = $referral_code;

        $employee->save();

        //  $employee->assignRole($request->role);
//        $mobile = $request->mobile;
//       $mobile = "9958038162";
//
//        $sms_message = "Dear " . $request->name . ", Your Positive Images Account is created. You may login to App with your mobile " . $mobile . " and password " . 'jhkhj';
//        $SMS_API_KEY = config('constants.SMS_API_KEY');
//        $sms_url = "https://api.textlocal.in/send/?apiKey=" . $SMS_API_KEY . "&sender=TXTLCL&numbers=91" . $mobile . "&message=" . urlencode($sms_message);
//        file_get_contents($sms_url);
        //exit($sms_url);

        if ($employee->id) {
            $employee_id = $employee->id;
            
     
              
            if ($request->hasFile('profile_image')) {
                $file = $request->file('profile_image');
                $time = time();
                if ($file->isValid()) {
                    $ext = strtolower($file->extension());
                    $file_name = "img" . "_" . $employee_id . "_" . $time . "." . $ext;
                    $path = $file->storeAs('employee/profile_image', $file_name);
                    $employee->profile_image = $path;
                    $employee->save();
                }
            }

            if (!empty($request->role)) {
                $user_role = new UserRole();
                $user_role->user_id = $employee_id;
                $user_role->role_id = $role_id;
                $user_role->save();
            }
            
           
        }
        
      DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
     flash_messages::add_message('s', 'Employee added successfully!');
        return flash_messages::display_message($request, $url = "owner/employee");
        
           
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
             flash_messages::add_message('e', 'Unable to add Employee. Please try again!'.$exp);
        return flash_messages::display_message($request, $url = "back");
            
           
        }
        
        
        
        
        
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_employee|view_employee');
        
        $row = Employee::findOrFail($id);

        $roles = Role::where('rg_code', '=', 'employees')->where('status', '=', 1)->get();
     //   dd($roles);
     $user_role_id = Auth::guard($this->guard_name)->user()->role_id;
        
                $roles = Role::where('status', '=', 1)
                
                ->Where('is_default', '=', 1)
                ->orWhere('is_default', '=', 0)
                ->where('belongs_to', '=', 'enterprise')
                
                ->get();
        $roles_array = $roles->toArray();
        $role_down = $this->role_down($roles_array,$user_role_id,true);
     $role_down_ids = $this->role_down_ids($role_down) ;
       
        
        return view('owner.employee.show', [
            'row' => $row,
             'roles' => $roles,
           'role_down_ids' => $role_down_ids,
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_employee|edit_employee');

        $row = Employee::findOrFail($id);
        $roles = Role::where('rg_code', '=', 'employees')->where('status', '=', 1)->get();
     
        return view('owner.employee.edit', [
            'row' => $row,
            'roles' => $roles,
          
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_employee|edit_employee');
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $employee = Employee::find($id); */

        $v = Validator::make($data, [
                    'name' => ['required', 'string', 'min:2', 'max:100'],
                    'email' => ['required', 'string', 'email', 'max:128'],
                    'mobile' => ['required', 'string', 'min:10', 'max:10'],
                   
                    'role' => ['required', 'string'],
                    'profile_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }


        $check_email = $this->check_unique_email($data['email'], $id);
        if (!empty($check_email->email)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_email['status']];

              flash_messages::add_message('e', 'This email already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
            
        
            // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }

        $check_mobile = $this->check_unique_mobile($data['mobile'], $id);
        if (!empty($check_mobile->mobile)) {
            $status = config('constants.USER_STATUS');
            $state = $status[$check_mobile['status']];
            
                flash_messages::add_message('e','This mobile already taken and in ' . $state . ' State. Kindly contact Administrator');
        return flash_messages::display_message($request, $url = "back");
            
         
        }

        
        
       
 try {
      DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction
      
        $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        $userid = Auth::guard('owner')->user()->id;
    //  dd($userid);

        
        
   $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');

        $employee = Employee::findorfail($id);
        //$employee->assignRole($request->role);

        $employee->name = $request->name;
       
        $employee->email = $request->email;

        $employee->mobile = $request->mobile;
        
        $exploded = explode('|', $request->role);
        $role_group = $exploded[0];
        $role_id = $exploded[1];
        $role_code = $exploded[2];

        $employee->role_group = $role_group;
        $employee->role = $role_code;
        $employee->role_id = $role_id;
       // $employee->guard = 'employee';
        $employee->address = $request->address;
        $employee->status = $request->status;
       
        $employee->email_verified = '1';
        $employee->email_verified_at= $current_timestamp;

 

        $employee->save();

        $employee_id = $id;

        
        
//            $employee_details = EmployeeDetail::where('employee_id',$employee_id)->first();
//         
//            $employee_details->address = $request->address;
//             $employee_details->name = $request->name;
//          //  $employee_details->employee_id = $employee_id;
//             $employee_details->gst_number = $request->gst_number;
//        
//        $employee_details->save();
        
        
        
        if ($request->hasFile('profile_image')) {
            $file = $request->file('profile_image');
            $time = time();
            if ($file->isValid()) {

                $filename_to_delete = storage_path() . '/app/' . $employee->profile_image;
                @unlink($filename_to_delete);

                $ext = strtolower($file->extension());
                $file_name = "img" . "_" . $employee_id . "_" . $time . "." . $ext;
                $path = $file->storeAs('employee/profile_image', $file_name);
                // dd($path);
                $employee->profile_image = $path;
                $employee->save();
                // save in database
            }
        }

        
              if (!empty($request->role)) {
                $user_role = UserRole::where('user_id','=',$employee_id)->first();
                if(empty($user_role)){
                    $user_role = new UserRole(); 
                }
                $user_role->user_id = $employee_id;
                $user_role->role_id = $role_id;
                $user_role->save();
            }
            
        
        
                if (!empty($request->enterprise)) {               
      
                   $this->sync_enterprise_user($request,$employee_id);
                }
        
        
        

            // return redirect()->back()->with('success', 'Data updated successfully!');
      
                DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                flash_messages::add_message('s','Updated successfully!');
                return flash_messages::display_message($request, $url = "back");
            
         
            
        } catch(\Exception $exp) {
            DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
            flash_messages::add_message('e', 'Unable to update employee details. Please try again!'.$exp);
            return flash_messages::display_message($request, $url = "back");   
           
        }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_employee|delete_employee');
        
        $row = Employee::where('id', $id)->first();
        if ($row->role == 'owner' || $row->role == 'superadmin') {
            return redirect('owner/employee')->with('error', 'This can not be deleted');
        }
        $row->status = '2';
        $row->save();
        return redirect('owner/employee')->with('success', 'Employee deleted successfully!');
    }

    public function check_unique_email($email, $id = 0) {
     //  check_permission('owner_employee|view_employee');
        
        $row = Employee::where('email', $email)->where('id', "!=", $id)->first();
        return $row;
    }

    public function check_unique_mobile($mobile, $id = 0) {
      // check_permission('owner_employee|view_employee');
        
        $row = Employee::where('mobile', $mobile)->where('id', "!=", $id)->first();
        return $row;
    }

    public function profile() {
        
        $id = Auth::guard($this->guard_name)->user()->id;
        $row = Employee::findOrFail($id);

        return view('owner.employee.profile', [
            'row' => $row,
        ]);
    }

    public function change_password() {
      // check_permission('owner_employee|view_employee');
        
        if (empty(Auth::guard($this->guard_name)->user()->id)) {
            return redirect('owner/login');
        }
        return view('owner.employee.change_password');
    }

    public function change_password_submit(Request $request) {
        if (empty(Auth::guard($this->guard_name)->user()->id)) {
            return redirect('owner/login');
        }
        $id = Auth::guard($this->guard_name)->user()->id;
        $email = Auth::guard($this->guard_name)->user()->email;
        $name = Auth::guard($this->guard_name)->user()->name;
        $current_password = $request->current_password;
        $db_current_password = Auth::guard($this->guard_name)->user()->password;

        // dd($hashed_current_password);
        $new_password = Hash::make($request->new_password);
        $pass = password_verify($request->new_password, $db_current_password);
//dd($current_password);
        if ($request->new_password != $request->confirm_password) {
            return redirect()->back()->with('error', 'Confirm password does not match!');
        } elseif ($pass == 1) {
            return redirect()->back()->with('error', 'New password cannot be same as Old password!');
        } elseif (Hash::check($current_password, $db_current_password)) {
            Employee::where('id', $id)->update(['password' => $new_password]);
            return redirect()->back()->with('success', 'Password updated successfully!');
        } else {
            return redirect()->back()->with('error', 'Old Password entered was invalid!');
        }
    }

    public function employee_role_grid(Request $req) {

        //  dd($req->id);
        $employee_id = $req->id;
        $roles = Role::where('status', '=', 1)->get();
        $employee_roles = UserRole::where('user_id', '=', $employee_id)->get();
        // dd($employee_roles);
        $existing_role_array = array();
        if (!empty($employee_roles) && count($employee_roles) > 0) {
            //  dd($module_role_permissions); 
            $existing_role_array = array();
            foreach ($employee_roles as $employee_role) {
                array_push($existing_role_array, $employee_role->role_id);
            }
        }
        // dd($existing_role_array) ;
        return view('owner.employee.employee_role_grid', [
            'roles' => $roles,
            'existing_role_array' => $existing_role_array,
            'user_id' => $employee_id,
        ]);
    }

    public function sync_role(Request $request) {
        //  dd($request->post());

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $employee = Permission::find($id); */

        $v = Validator::make($data, [
                    // 'roles' => ['required'],          
                    'user_id' => ['required', 'integer'],
        ]);


        //dd($v->errors());
        if ($v->fails()) {
//             flash_messages::add_message('e',$v->errors()->all());
//            return flash_messages::display_message(true);          
            return redirect()->back()->withErrors($v)->withInput($data);
        }

        $employee_id = $data['user_id'];


        if (!empty($data['roles']) && count($data['roles']) > 0) {
            $roles = $data['roles'];
            $delete_existing = UserRole::where('user_id', '=', $employee_id)->delete();

            $insert_data = array();
            foreach ($roles as $role) {

                $insert_one = array('user_id' => $employee_id, 'role_id' => $role);
                array_push($insert_data, $insert_one);
            }

            $save = UserRole::insert($insert_data);
            // dd($save);
            if ($save) {
                return redirect()->back()->withSuccess('Roles synced successfully');
            } else {
                return redirect()->back()->withErrors('Cannot sync Roles')->withInput($data);
            }
        } else {
            $check_existing = UserRole::where('user_id', '=', $employee_id)->get();
            if (!empty($check_existing) && count($check_existing) > 0) {
                $delete_existing = UserRole::where('user_id', '=', $employee_id)->delete();
                return redirect()->back()->withSuccess('Roles synced successfully')->withInput($data);
            } else {
                return redirect()->back()->withErrors('Cannot sync Roles')->withInput($data);
            }
        }
    }

    
        public function reset_password_to_default(Request $request,$id=0) {
        //dd($id);
         $row = Employee::findOrFail($id);
         
        
        
     
          
             $row->password = Hash::make(config('constants.DEFAULT_PASSWORD'));
             $saved = $row->save();
             if($saved == true){
                     flash_messages::add_message('s', 'Password reset to default');
                    return flash_messages::display_message($request, $url = "owner/employee"); 
                    
                     //return redirect('owner/employee')->with('success','Password reset to default');
             }else{
                  flash_messages::add_message('e', 'Password reset failed');
            return flash_messages::display_message($request, $url = "owner/employee");   
            
               //  return redirect('owner/employee')->with('error','Password reset failed'); 
             }
       
        
      //  return redirect('employee/employee')->with('success','Password Reset to Default');
            
        return view('owner.employee.index');
    }
}
