<?php

namespace App\Http\Controllers\owner;

use Illuminate\Session\Store;
use Session;

use App\Http\Controllers\owner\OwnerBaseController;
use Illuminate\Http\Request;
use App\Models\DocumentDownload;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use View;
use Carbon\Carbon;

class DocumentDownloadController extends OwnerBaseController {

    public function __construct(Store $session){
        parent::__construct($session);
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {
//


 //check_permission('owner_document_download|view_document_download');
        return view('owner.document_download.index');
    }

    public function document_download_grid(Request $req) {
     //  check_permission('owner_document_download|view_document_download');
        
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
        $search_coloumns = ['name', 'id', 'email'];
        if (!empty($search_term)) {
            $rows = DocumentDownload::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                            $q->orWhere($field, 'like', "%{$search_term}%");
                    })->where('id', '>=', 1)
                   
                  
                    ->paginate($limit);
        } else {
            $rows = DocumentDownload::where('id', '>=', 1)
                    ->paginate($limit);
        }

        return view('owner.document_download.document_download_grid', ['result_data' => $rows]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request) {
       //check_permission('owner_document_download|create_document_download');
        flash_messages::add_message('e', 'Access Denied: Owners Cannot create inquiries');
        return flash_messages::display_message($request, $url = "back");
            
       
        return view('owner.document_download.create', [
          
        ]);
    }


    
    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
      // check_permission('owner_document_download|create_document_download');
             
        
        flash_messages::add_message('e', 'Access Denied');
        return flash_messages::display_message($request, $url = "back");
            
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
      // check_permission('owner_document_download|view_document_download');
         flash_messages::add_message('e', 'Access Denied: Owners Cannot view');
        return flash_messages::display_message($request, $url = "back");
            
        $row = DocumentDownload::findOrFail($id);

      
        return view('owner.document_download.show', [
            'row' => $row,
           
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
       //check_permission('owner_document_download|edit_document_download');
 flash_messages::add_message('e', 'Access Denied: Owners Cannot edit');
        return flash_messages::display_message($request, $url = "back");
            
        $row = DocumentDownload::findOrFail($id);
      
     
        return view('owner.document_download.edit', [
            'row' => $row,
            
          
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {
      // check_permission('owner_document_download|edit_document_download');
        
         flash_messages::add_message('e', 'Access Denied: Owners Cannot update');
        return flash_messages::display_message($request, $url = "back");
            
        
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /* $document_download = DocumentDownload::find($id); */

        $v = Validator::make($data, [
                      'name' => ['required', 'string', 'min:2', 'max:100'],
                    'designation' => ['required', 'string', 'min:2', 'max:100'],
                    'priority' => ['required', 'integer', 'max:100'],
                    'facebook_link' => [ 'string', 'min:2', 'max:255'],
                    'instagram_link' => [ 'string', 'min:2', 'max:255'],
                    'linkedin_link' => [ 'string', 'min:2', 'max:255'],
                    'twitter_link' => [ 'string', 'min:2', 'max:255'],                  
                    'status' => ['required', 'integer', 'max:99'],
                    'document_download_image' => 'image|mimes:jpeg,jpg|max:2048',
        ]);


        //dd($v->errors());
        if ($v->fails()) {
           
                flash_messages::add_message('e', $v->errors()->all());
        return flash_messages::display_message($request, $url = "back");
            
            
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        try {
             DB::beginTransaction(); // Tell Laravel all the code beneath this is a transaction

               $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');
               $userid = Auth::guard('owner')->user()->id;
           //  dd($userid);



          $current_timestamp = Carbon::now();
               $today = $current_timestamp->format('Y-m-d');

               $document_download = DocumentDownload::findorfail($id);
        
        $document_download->name = $request->name;
        $document_download->designation = $request->designation;
        $document_download->priority_order = $request->priority;
        $document_download->facebook_link = $request->facebook;
        $document_download->instagram_link = $request->instagram;
        $document_download->linkedin_link = $request->linkedin;
        $document_download->twitter_link = $request->twitter;
        $document_download->status = $request->status;
       
        $document_download->updated_by = $userid;
        $document_download->updated_at = $current_timestamp;
        $document_download->created_by = $userid;
        $document_download->created_at = $current_timestamp;
       


               $document_download->save();

               $document_download_id = $id;

               if ($request->hasFile('document_download_image')) {
                   $file = $request->file('document_download_image');
                   $time = time();
                   if ($file->isValid()) {

                       $filename_to_delete = storage_path() . '/app/' . $document_download->image;
                       @unlink($filename_to_delete);

                       $ext = strtolower($file->extension());
                       $file_name = "img" . "_" . $document_download_id . "_" . $time . "." . $ext;
                       $path = $file->storeAs('document_download/document_download_image', $file_name);
                       // dd($path);
                       $document_download->image = $path;
                       $document_download->save();
                       // save in database
                   }
               }

                       DB::commit(); // Tell Laravel this transacion's all good and it can persist to DB
                       flash_messages::add_message('s','Updated successfully!');
                       return flash_messages::display_message($request, $url = "back");



               } catch(\Exception $exp) {
                   DB::rollBack(); // Tell Laravel, "It's not you, it's me. Please don't persist to DB"
                   flash_messages::add_message('e', 'Unable to update document_download details. Please try again!'.$exp);
                   return flash_messages::display_message($request, $url = "back");   

               }
         
        
        
        
        
        
        
        
        
       
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
      // check_permission('owner_document_download|delete_document_download');
        
        $row = DocumentDownload::where('id', $id)->first();
      
        $row->status = '2';
        $row->save();
        return redirect('owner/document_download')->with('success', 'DocumentDownload deleted successfully!');
    }


}
