<?php

namespace App\Http\Controllers\Owner\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class OwnerResetPasswordController extends Controller
{
    public function showResetForm(Request $request, $token = null)
    {
        return view('owner.auth.reset-password', [
            'token' => $token,
            'email' => $request->query('email')
        ]);
    }

    public function reset(Request $request)
    {
        $request->validate([
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|min:8|confirmed',
        ]);

        $status = $this->broker()->reset(
            $request->only('email','password','password_confirmation','token'),
            function ($user) use ($request) {
                $user->forceFill([
                    'password' => Hash::make($request->password),
                    'remember_token' => Str::random(60),
                ])->save();
            }
        );

        if ($request->wantsJson()) {
            return response()->json([
                'status' => $status === Password::PASSWORD_RESET,
                'message' => __($status),
                'redirect' => $status === Password::PASSWORD_RESET ? route('owner.password.request') : null
            ], $status === Password::PASSWORD_RESET ? 200 : 422);
        }

        return $status === Password::PASSWORD_RESET
            ? redirect()->route('owner.password.request')->with('success', __($status))
            : back()->withErrors(['email' => [__($status)]]);
    }

    protected function broker()
    {
        return Password::broker('owners');
    }
}
