<?php

namespace App\Http\Controllers\Owner\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;

class OwnerForgotPasswordController extends Controller
{
    public function showForm()
    {
        return view('owner.auth.forgot-password');
    }

    public function sendResetLink(Request $request)
    {
        $request->validate(['email' => 'required|email']);

        $status = $this->broker()->sendResetLink($request->only('email'));

        if ($request->wantsJson()) {
            return response()->json([
                'status' => $status === Password::RESET_LINK_SENT,
                'message' => __($status)
            ], $status === Password::RESET_LINK_SENT ? 200 : 422);
        }

        return $status === Password::RESET_LINK_SENT
            ? back()->with('success', __($status))
            : back()->withErrors(['email' => __($status)]);
    }

    protected function broker()
    {
        return Password::broker('owners');
    }
}
