<?php

namespace App\Http\Controllers\front\auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;


class LoginController extends Controller
{
    //
    public function index(){
       // dd('general');
        return view('general.login');
    }

     public function authenticate(Request $request){
       // dd($request->all());
        $validator = Validator::make($request->all(),[
            'email'=>'required|email',
            'password'=>'required',
        ]);

        if($validator->passes()){

            if(Auth::guard('admin')->attempt(['email'=>$request->email,'password'=>$request->password])){
                if(Auth::guard('admin')->user()->role != 'admin'){
                    Auth::guard('admin')->logout();
                     return redirect()->route('admin.login')->withInput()->with('error','You are not authorised to access this page');
                }
                 return redirect()->route('admin.dashboard')->with('success','Login Successfull.'); 
            }else{
               return redirect()->route('admin.login')->with('error','Invalid login credentials.'); 
            }
//dd('asdasdasd');
        }else{
            return redirect()->route('admin.login')->withInput()->withErrors($validator);
        }


    }

    public function logout(){
        Auth::guard('admin')->logout();
        return redirect()->route('admin.login')->with('success','Logout Successfully.'); 
    }

}
