<?php

namespace App\Http\Controllers\front;

use App\Helpers\flash_messages;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller ;

use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use Carbon\Carbon;


use App\Models\Inquiry;
use App\Models\Project ;
use App\Models\ScaffoldingCategory;
use App\Models\ScaffoldingProduct ;
use App\Models\Training ;
use App\Models\Document ;
use App\Models\Gallery ;
use App\Models\Team ;
use App\Models\DocumentDownload ;
use Response;
use Illuminate\Support\Facades\Storage;

use Illuminate\Support\Facades\Mail;

class FrontController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
        $scaffolding_categories = $this->get_scaffolding_categories_for_header();
        View::share('scaffolding_categories',$scaffolding_categories);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    
    public function get_scaffolding_categories_for_header(){
         $scaffolding_categories = ScaffoldingCategory::where('parent_id','=',0)->where('status',1)->orderBy('sort_order', 'asc')->get();
         
        
         
         return $scaffolding_categories;
    }
    
    public function index()
    {
        return view('front.index',[
         //   'scaffolding_categories'=>$scaffolding_categories,
        ]);
    }
    
    
    public function pricing()
    {
         $packages = Package::with('package_module', 'package_module.module')->where('status', 1)->get();
        return view('front.pricing',[
            'packages'=>$packages,
        ]);
    }
    public function about_us()
    { 
        return view('front.about_us');
    }
    public function contact_us()
    { 
        return view('front.contact_us');
    }
    public function certificate()
    { 
        return view('front.certificate');
    }
    public function certificate_submit(Request $request){         
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

            $v = Validator::make($data, [
                'name' => ['required', 'string', 'min:2', 'max:100'],
                'email' => ['required','email', 'string', 'min:2', 'max:100'],            
                'mobile' => ['required', 'string', 'min:10', 'max:10'],                
            ]);
            
        //dd($v->errors());
        if ($v->fails()) {            
            flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }
        
             $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
        
        $email = $request->email;
        $name = $request->name;
        
        $check_attachments = \App\Models\TrainingCertificate::where('email',$email)->get();
        if (empty($check_attachments) || count($check_attachments) < 1) {            
            flash_messages::add_message('e', 'No Certificate belongs to this email id. Please check email');
            return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }
        
      // dd($check_attachments);
       
      
              
           // $this->contact_us_email_to_admin($inquiry,$request);
           
          //  $admin_email = config('constants.ADMIN_EMAIL') ;
            $subject = "Training Certificate from Atulya Scaffolding Safety and Services";
            $body = view('common.templates.emails.certificate_email_to_user', ['row' => $check_attachments,'name'=>$name])->render();
    //  dd($body);
    //     Mail::html($body, function ($message) use ($to, $subject) {
    //         $message->to($to)
    //                 ->subject($subject)
    //                 ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
    //     });
   
     Mail::html($body, function ($message) use($email,$subject,$check_attachments){
         $message->to($email, 'Atulya Scaffolding Safety and Service LLP')
                    ->subject($subject)
                    ->from('no-reply@atulyascaffolding.com', 'Atulya Scaffolding Safety and Service LLP');
         
                    // **Iterate through the attachments and call ->attach() for each one**
                foreach ($check_attachments as $attachment) {

                  
                     // Define the full path to the file on the server.
                    $filePath = storage_path('app/private/' . $attachment->path);

                    // Check if the file exists before attempting to attach it.
                    if (file_exists($filePath)) {
                        $randomNumber = mt_rand();
                        $message->attach($filePath, [
                            // Use the file_name from the database for the displayed name
                            'as' => $attachment->name.$randomNumber ?? basename($attachment->name),
                            'mime' => 'application/pdf',
                            // You can optionally add 'mime' => 'application/pdf' here
                        ]);
                    }
                }
     });
           
            
//        if($row->email != "") {
//          $this->contact_us_thanks_email_to_user($row);
//        }

           flash_messages::add_message('s', 'Thank you, Your Message Sent to us. We will contact you soon');
            return flash_messages::display_message($request,'back');
           
        
    }
    
    
     public function contact_us_submit(Request $request){         
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

            $v = Validator::make($data, [
                'name' => ['required', 'string', 'min:2', 'max:100'],
                'email' => ['required','email', 'string', 'min:2', 'max:100'],            
                'subject' => ['required', 'string', 'min:5', 'max:100'],
                'message' => ['required', 'string', 'min:5', 'max:255'],
            ]);
            
        //dd($v->errors());
        if ($v->fails()) {            
            flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }
        
             $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
            
              $inquiry = new Inquiry();
        
        $inquiry->name = $request->name;
        $inquiry->email = $request->email;
        $inquiry->subject = $request->subject;
        $inquiry->message = $request->message;
        $inquiry->created_at = $current_timestamp;
       
        $inquiry->save();

        if ($inquiry->id){
              
           // $this->contact_us_email_to_admin($inquiry,$request);
           
          //  $admin_email = config('constants.ADMIN_EMAIL') ;
            $admin_email = 'info@atulyascaffolding.com';
            $subject = "Thank You for Contacting Us";
            $body = view('common.templates.emails.contact_us_email_to_admin', ['row' => $inquiry])->render();
    //  dd($body);
    //     Mail::html($body, function ($message) use ($to, $subject) {
    //         $message->to($to)
    //                 ->subject($subject)
    //                 ->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
    //     });
   
     Mail::html($body, function ($message) use($admin_email,$subject){
         $message->to($admin_email, 'Atulya Scaffolding Safety and Service LLP')
                 ->subject($subject)
                ->from('no-reply@atulyascaffolding.com', 'Atulya Scaffolding Safety and Service LLP');
     });
           
            
//        if($row->email != "") {
//          $this->contact_us_thanks_email_to_user($row);
//        }

           flash_messages::add_message('s', 'Thank you, Your Message Sent to us. We will contact you soon');
            return flash_messages::display_message($request,'back');
           
        }else{
          flash_messages::add_message('e', 'Unable to Send message. Please try again!');
            return flash_messages::display_message($request,'back');  
        }
    }
    
     public function contact_us_email_to_admin($row,$request) {
        // send email to user
 
         // send email to admin
       // $to = getConfigData('ADMIN_EMAIL');
        $to = 'sourabh.varun.verma@gmail.com';
        $subject = 'New Contact Us Enquiry Received';
        $view = \View::make('common/templates/emails/contact_us_email_to_admin', ['row' => $row]);
        $body = $view->render();
        dd($body);
        $data['from'] = array(env('MAIL_USERNAME') => env('EMAIL_SENDER'));
        $data['to'] = $to;
        $data['subject'] = $subject;
        $data['body'] = $body;
        
        
        try {
            Mail::send([], [], function($message) use ($data) {
                $message->from($data['from']);
                $message->to($data['to']);
                $message->subject($data['subject']);
                $message->setBody($data['body'], 'text/html');
            });
        } catch (\Exception $e) {
            //dd($e);
             flash_messages::add_message('e', 'Oops! Some error occured in sending email to admin.');
            return flash_messages::display_message($request,'back');  
            //return redirect()->back()->withError('Oops! Some error occured in sending email to admin.');
        }
    } 
    
    
    
      public function contact_us_thanks_email_to_user($row) {
        // send email to user
        $to = $row->email;
        $subject = 'Welcome to ' . config('constants.APP_NAME');
        $view = \View::make('admin/templates/emails/contact_us_thanks_email_to_user', ['row' => $row]);
        $body = $view->render();
        
        $data['from'] = array(env('MAIL_USERNAME') => env('EMAIL_SENDER'));
        $data['to'] = $to;
        $data['subject'] = $subject;
        $data['body'] = $body;
        //dd($data);
        try {
            Mail::send([], [], function($message) use ($data) {
                $message->from($data['from']);
                $message->to($data['to']);
                $message->subject($data['subject']);
                $message->setBody($data['body'], 'text/html');
            });
        } catch (\Exception $e) {
            //dd($e);
            return redirect()->back()->withError('Oops! Some error occured in sending email to user.');
        }
    } 
    
    
     
    
     public function training(Request $request){
      
          $limit = 10;
         $trainings = Training::where('status', '=', 1)
                    ->orderBy('updated_at', 'DESC')
                    ->paginate($limit);
         $recents = Training::where('status', '=', 1)
                    ->orderBy('updated_at', 'DESC')
                    ->limit(5)
                    ->get();
       
         return view('front.training',[
             'trainings'=>$trainings,
             'recents'=>$recents,
            
         ]);
    }
    
      public function training_single($id=''){    
     // dd($id);
      $training_single = Training::where('status',1)->findOrfail($id);
       $recents = Training::where('status', '=', 1)
                    ->orderBy('updated_at', 'DESC')
                    ->limit(5)
                    ->get();
      return view('front.training_single',[
             'training_single'=>$training_single,
             'recents'=>$recents,
         ]);  
    }
    
    
    
     public function team(Request $request){
         $leaderships = Team::where('status', 1)->where('priority_order','=',1)->get();
         $members = Team::where('status', 1)->where('priority_order','>',1)->get();
         return view('front.team',[
             'leaderships'=>$leaderships,
             'members'=>$members
         ]);
    }
    
    

     public function gallery(Request $request){ 
          $galleries = Gallery::where('status', 1)->get();
         return view('front.gallery',[
             'galleries'=>$galleries,
         ]);
    }

     public function projects(Request $request){
          $projects = Project::where('status', 1)->get();
         // dd($projects);
         return view('front.projects',[
             'projects'=>$projects,
         ]);           
    }
    
     public function scaffolding_services(Request $request){
//         $scaffolding_services = ScaffoldingCategory::with('children_categories','children_categories.children_categories')
//                 ->where('slug','=','scaffolding-services')
//                 ->where('status',1)
//                 ->orderBy('sort_order','ASC')
//                 ->first();
//         

        $scaffolding_services = ScaffoldingCategory::with(
                                        [
                                        'children_categories' => function ($query) {
                                            $query->where('status', 1);
                                            $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                            },
                                        'children_categories.children_categories' => function ($query) {
                                                 $query->where('status', 1);
                                            $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                            }
                                        ]
                                    )->where('slug','=','scaffolding-services')
                                    ->where('status',1)
                                    ->orderBy('sort_order','asc')
                                    ->first();
         
       //  dd($scaffolding_services->children_categories);
         return view('front.scaffolding_services',[
             'scaffolding_services'=>$scaffolding_services,
         ]);           
    }
    
           public function scaffolding_single($id=''){    
   
      $scaffolding_single = ScaffoldingCategory::with(
                                        [
                                        'children_categories' => function ($query) {
                                            $query->where('status', 1);
                                            $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                            },
                                        'children_categories.children_categories' => function ($query) {
                                                 $query->where('status', 1);
                                            $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                            }
                                        ]
                                    )
                                    ->where('status',1)
                                   
                                    ->findOrfail($id);
                                    
                $scaffolding_services = ScaffoldingCategory::with(
                                      [
                                      'children_categories' => function ($query) {
                                          $query->where('status', 1);
                                          $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                          },
                                      'children_categories.children_categories' => function ($query) {
                                               $query->where('status', 1);
                                          $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                          }
                                      ]
                                  )->where('slug','=','scaffolding-services')
                                  ->where('status',1)
                                  ->orderBy('sort_order','asc')
                                  ->get();

      
      return view('front.scaffolding_single',[
             'scaffolding_cats'=>$scaffolding_services,
             'scaffolding_single'=>$scaffolding_single,
             'scaffolding_id'=>$id,
         ]);  
    }
    
    
     public function scaffolding_material(Request $request){        
         $scaffolding_products = ScaffoldingProduct::where('status',1)->get();
         return view('front.scaffolding_product',[
             'scaffolding_products'=>$scaffolding_products,
         ]);              
    }
     public function scaffolding_product(Request $request){ 
         $scaffolding_products = ScaffoldingProduct::where('status',1)->get();
         return view('front.scaffolding_product',[
             'scaffolding_products'=>$scaffolding_products,
         ]);           
    }
     public function downloads(Request $request){ 
        // $documents = Document::where('status',1)->get();
         
         $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');
            $documents = Document::where('status', '=', 1)->paginate($limit);
         return view('front.download',[
             'documents'=>$documents,
         ]);           
    }
    
    //   public function download_file($path=''){     
    //     if($path != "" && Storage::exists($path)) {
    //      return Storage::download($path);
    //     }

    //     return back()->with('error', 'File not found.');
    // }
    
    
        public function download_file(Request $request,$path=''){
         // dd($request);
           $data = $request->all();
     //dd($data);
        unset($data['_method']);
        unset($data['_token']);

            $v = Validator::make($data, [
                'name' => ['required', 'string', 'min:2', 'max:100'],
                'email' => ['required','email', 'string', 'min:2', 'max:100'],            
              
            ]);
            
        //dd($v->errors());
        if ($v->fails()) {            
            flash_messages::add_message('e', $v->errors()->all());
           // return flash_messages::display_message($request, $url = "back");
            //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }
        
             $current_timestamp = Carbon::now();
        $today = $current_timestamp->format('Y-m-d');
            
              $document_download = new DocumentDownload();
        
        $document_download->name = $request->name;
        $document_download->email = $request->email;
       // $document_download->subject = $request->subject;
        $document_download->file_path = $request->file_path;
        $document_download->file_name = $request->file_name;
        $document_download->created_at = $current_timestamp;
       
        $document_download->save();

        $file_path = $request->file_path;
        $row_path = $request->row_path;
       // dd($file_path);
         if ($document_download->id){              
               if($row_path != "" && Storage::exists($row_path)) {
                return Storage::download($row_path);
               // return Response::download($absolutePath, $fileName);
                  // dd($data);
               }
           flash_messages::add_message('s', 'File Download successfull.');
            return flash_messages::display_message($request,'back');
           
        }else{
          flash_messages::add_message('e', 'Unable to download. Please try again!');
            return flash_messages::display_message($request,'back');  
        }
        
         // DocumentDownload
          
      
        return back()->with('error', 'File not found.');
    }
    
    
    
    
     public function scaffolding_design(Request $request){ 
          $scaffolding_design = ScaffoldingCategory::with(
                                        [
                                        'children_categories' => function ($query) {
                                            $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                            },
                                        'children_categories.children_categories' => function ($query) {
                                            $query->orderBy('sort_order', 'asc'); // Sort comments by creation date descending
                                            }
                                        ]
                                    )->where('slug','=','scaffolding-design')
                                    ->where('status',1)
                                    ->orderBy('sort_order','asc')
                                    ->first();
                                        
                                      //  dd($scaffolding_design);
         return view('front.scaffolding_design',[
             'scaffolding_design'=>$scaffolding_design,
         ]);           
    }
     public function blog(Request $request){ 
         return view('front.blog');           
    }

     public function terms_and_conditions(Request $request){ 

         return view('front.terms_and_conditions');
           
    }
     public function privacy_policy(Request $request)
    { 
         return view('front.privacy_policy');
           
    }
}
