<?php

use App\Models\admin\Configuration;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
//use Gate;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\File;
use Illuminate\Support\Facades\Storage;

function getConfigData($index = "")
{
    // get config data
    $data = Configuration::all();
    $configData = array();
    foreach ($data as $key => $value) {
        $configData[$value->attr_name] = $value->attr_value;
    }
    if ($index == "") {
        return $configData;
    } else {
        if (!empty($configData[$index])) {
            return $configData[$index];
        } else {
            return 'Invalid Attribute Name Called';
        }
    }
}

function getOrderStatus($status)
{
    $ORDER_STATUS = config('constants.ORDER_STATUS');
    return $ORDER_STATUS[$status];
}

function getOrderStatusApplicable($status)
{
    $ORDER_STATUS_APPLICABLE = config('constants.ORDER_STATUS_APPLICABLE');
    return $ORDER_STATUS_APPLICABLE[$status];
}

function getUserPlatforms($index = "0")
{
    $User_Platforms = config('constants.User_Platforms');
    return "(" . $User_Platforms[$index] . ")";
}

function get_showing_text($page_size, $page, $total_products)
{
    $total_page = ceil($total_products / $page_size);
    $page = (int) $page;
    if ($page == 1) {
        $start = ($total_products > 0) ? 1 : 0;
        $end = ($page_size > $total_products) ? $total_products : $page_size;
    } else if ($page > 1 && $page < $total_page) {
        $start = ($page_size * ($page - 1)) + 1;
        $end = ($page_size * ($page - 1)) + $page_size;
    } else if ($page == $total_page) {
        $start = ($page_size * ($page - 1)) + 1;
        $end = $total_products;
    } else if ($page <= 0) {
        abort(404);
    } else if ($page > $total_page) {
        abort(404);
    }

    if ($total_products > 0) {
        $showing_text = 'Showing ' . $start . '-' . $end . ' of ' . $total_products . ' Results.';
    } else {
        $showing_text = 'Showing ' . $start . '-' . $end . ' of ' . $total_products . ' Results.' . ' ' . '<a class="text-info" href="' . url('shop') . '">Clear All Filters</a>';
    }

    return $showing_text;
}


function is_decimal($val)
{
    return is_numeric($val) && floor($val) != $val;
}


function price_format($price, $round_off = true)
{
    $return = $price;
    if ($round_off == true) {
        $return = number_format(round($return));
    } else {
        if (is_decimal($return)) {
            $return = (float) number_format($return, 2);
        } else {
            $return = number_format($return);
        }
    }
    //dd($return);
    return $return;
}


function get_date($date, $format_from = "Y-m-d H:i:s", $format_to = "d M Y, h:i A")
{
    $new_date = "";
    if (DateTime::createFromFormat($format_from, $date) !== FALSE) {
        // it is a valid date
        $new_date = date_format(DateTime::createFromFormat($format_from, $date), $format_to);
    } /*else {
        $date = date("Y-m-d H:i:s");
        $new_date = date_format(DateTime::createFromFormat("Y-m-d H:i:s", $date), $format_to);
    }*/
    return $new_date;
}

function get_substr($string, $limit = 28)
{
    return (strlen($string) > $limit) ? Str::substr($string, 0, $limit) . ' ...' : $string;
}

function generate_random_number($length = 6)
{
    $characters = '0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function generate_random_string($length = 6)
{
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}

function slugify($text)
{
    // replace non letter or digits by -
    $text = preg_replace('~[^\pL\d]+~u', '-', $text);
    // transliterate
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);
    // trim
    $text = trim($text, '-');
    // remove duplicate -
    $text = preg_replace('~-+~', '-', $text);
    // lowercase
    $text = strtolower($text);
    if (empty($text)) {
        return 'n-a';
    }
    return $text;
}

function slugify_underscore($text)
{
    // replace non letter or digits by -
    $text = preg_replace('~[^\pL\d]+~u', '_', $text);
    // transliterate
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    // remove unwanted characters
    $text = preg_replace('~[^-\w]+~', '', $text);
    // trim
    $text = trim($text, '_');
    // remove duplicate -
    $text = preg_replace('~-+~', '_', $text);
    // lowercase
    $text = strtolower($text);
    if (empty($text)) {
        return 'n_a';
    }
    return $text;
}

function check_gate($module_permission = ''){
    //['superadmin', 'owner', 'employee','parent','student','web']
    // ********* THis array is no. of guards i am using in th application
    //          Without this function this can be used used          as ;

    //          $user = Auth::guard('employee')->user(); // or admin/franchise/etc

    // if ($user && Gate::forUser($user)->allows('student|view')) {
    //     // Permission granted
    // } else {
    //     // Access denied
    // }
//  dd($module_permission);
    $guards = config('auth.guards');

    $guard_array = [];
    foreach ($guards as $guardName => $guardConfig) {
        // echo "Guard Name: " . $guardName . "\n";
        // echo "  Driver: " . $guardConfig['driver'] . "\n";
        // echo "  Provider: " . $guardConfig['provider'] . "\n";
        // ... access other guard properties
        array_push($guard_array, $guardName);
    }
    //dd($guard_array);
    //   foreach (['superadmin', 'owner', 'employee','parent','student','web'] as $guard) {
    foreach ($guard_array as $guard) {
        if (Auth::guard($guard)->check()) {
            return Gate::forUser(Auth::guard($guard)->user())->allows($module_permission);
        }
    }
    return false;
}

function check_permission($module_permission = '')
{

    //['superadmin', 'owner', 'employee','parent','student','web']
    // ********* THis array is no. of guards i am using in th application
    //          Without this function this can be used used          as ;

    //          $user = Auth::guard('employee')->user(); // or admin/franchise/etc
    $check = check_gate($module_permission);
    //dd($check);
    if ($check) {
        // Permission granted
        return true;
    } else {
        // Access denied
        abort(403, response(view('errors.403')));
    }

}


function check_not_permission($module_permission = '')
{
    if (Gate::allows($module_permission)) {
        //       # Regular response
        //        abort( response('Unauthorized', 401) );
        //        # JSON response 
        //        abort( response()->json('Unauthorized', 401) );

        abort(403, response(view('errors.403')));

        // return response(view('errors.403'),403);
    }
}

function create_image_path($path = "")
{
  // print_r(storage_path($path));
    //if (\File::exists(storage_path('private/' . $path)) && $path != "") {
         //print_r(storage_path('app/' . $path));
     //   dd($path);
       if($path != "" && Storage::exists($path)) {
      //  dd('trueeeeeee');
        return url('storage/app/private/' . $path);
    } else {

      
        return url(config('constants.IMAGE_NOT_FOUND'));
    }
}

function create_file_path($path = "")
{
  // print_r(storage_path($path));
    //if (\File::exists(storage_path('private/' . $path)) && $path != "") {
         //print_r(storage_path('app/' . $path));
     //   dd($path);
       if($path != "" && Storage::exists($path)) {
      //  dd('trueeeeeee');
        return url('storage/app/private/' . $path);
    } else {

      
        return url(config('constants.FILE_NOT_FOUND'));
    }
}

function getPrivateImageUrl(string $relativePath = ""): string
{
    // Ensure the path is not empty
    if (empty($relativePath)) {
        return url(config('constants.IMAGE_NOT_FOUND', '/images/placeholder.png')); // Provide a default placeholder path
    }

    // Use Laravel's Storage facade to check if the file exists on the default 'local' disk (storage/app)
    if (Storage::disk('local')->exists($relativePath)) {
        // If the file exists, return a URL to a dedicated route that will serve this private image.
        // You MUST have a route defined like: Route::get('/private-images/{filename}', [ImageUploadController::class, 'servePrivateImage'])->name('private.image.show');
        // The filename passed to the route should be just the filename, not the full relative path.
        // So, if $relativePath is 'private_images/my_image.jpg', we need to extract 'my_image.jpg'.
        $filename = basename($relativePath);
        return route('private.image.show', ['filename' => $filename]);
    } else {
        // If the file does not exist, return a placeholder image URL.
        // Ensure 'constants.IMAGE_NOT_FOUND' is defined in config/constants.php
        // or provide a direct URL to a placeholder image in your public folder.
        return url(config('constants.IMAGE_NOT_FOUND', '/images/placeholder.png'));
    }
}

function create_theme_image_path($theme_path = "")
{
    if (\File::exists($theme_path . '/screenshot.png') && $theme_path != "") {

        $theme_folder_name = basename($theme_path);
        $img_src = config('constants.THEMES_URL') . '/' . $theme_folder_name . '/screenshot.png';
        return $img_src;
    } else {
        return url(config('constants.IMAGE_NOT_FOUND_THEME'));
    }
}

function create_image_link($link = "")
{

    return  url('/');
}



function datetime_to_text($datetime = "")
{
    $unixdatetime = strtotime($datetime);
    return strftime("%B %d, %Y  %I:%M %p", $unixdatetime);
}


function date_to_text($date = "")
{
    $unixdate = strtotime($date);
    return strftime("%B %d, %Y", $unixdate);
}

function date_difference_absolute($date1, $date2)
{
    $difference = abs(strtotime($date1) - strtotime($date2));
    $difference_array['hours'] = ceil($difference / (60 * 60));
    $difference_array['days'] = floor($difference_array['hours'] / 24);
    $difference_array['extra_hours'] = abs($difference_array['hours'] % 24);

    return $difference_array;
}

function date_difference($date1, $date2)
{
    $difference = (strtotime($date1) - strtotime($date2));
    $difference_array['hours'] = ceil($difference / (60 * 60));
    $difference_array['days'] = floor($difference_array['hours'] / 24);
    $difference_array['extra_hours'] = abs($difference_array['hours'] % 24);

    return $difference_array;
}

function utc_to_indian($utc_time)
{
    //$utc = date("Y-m-d H:i:s");
    $dt = new DateTime($utc_time);
    $tz = new DateTimeZone('Asia/Kolkata'); // or whatever zone you're after
    $dt->setTimezone($tz);
    $indian_time = $dt->format('Y-m-d H:i:s');

    return $indian_time;
}
