<!--
 // WEBSITE: https://themefisher.com
 // TWITTER: https://twitter.com/themefisher
 // FACEBOOK: https://www.facebook.com/themefisher
 // GITHUB: https://github.com/themefisher/
-->

<!-- 
THEME: Constra - Construction Html5 Template
VERSION: 1.0.0
AUTHOR: Themefisher

HOMEPAGE: https://themefisher.com/products/constra-construction-template/
DEMO: https://demo.themefisher.com/constra/
GITHUB: https://github.com/themefisher/Constra-Bootstrap-Construction-Template

WEBSITE: https://themefisher.com
TWITTER: https://twitter.com/themefisher
FACEBOOK: https://www.facebook.com/themefisher
-->

<!DOCTYPE html>
<html data-base-url="<?php echo e(url('/')); ?>" lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>

  <!-- Basic Page Needs
================================================== -->
  <meta charset="utf-8">
  <title>Atulya Scaffolding Safety and Services LLP</title>

  <!-- Mobile Specific Metas
================================================== -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="description" content="Construction Html5 Template">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
  <meta name=author content="Themefisher">
  <meta name=generator content="Themefisher Constra HTML Template v1.0">

  <!-- Favicon
================================================== -->
  <link rel="icon" type="image/png" href="<?php echo e(asset('public/front/images/favicon.png')); ?>">

  <!-- CSS
================================================== -->
  <!-- Bootstrap -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/bootstrap/bootstrap.min.css')); ?>">
  <!-- FontAwesome -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/fontawesome/css/all.min.css')); ?>">
  <!-- Animation -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/animate-css/animate.css')); ?>">
  <!-- slick Carousel -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/slick/slick.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/slick/slick-theme.css')); ?>">
  <!-- Colorbox -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/colorbox/colorbox.css')); ?>">
  <!-- Template styles-->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/css/style.css')); ?>">

</head>
<body>
  <div class="body-inner">
    
<?php $__env->startSection('topbar'); ?>
 
 <?php echo $__env->make('front.layouts.topbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>

<?php $__env->startSection('header'); ?>
 
 <?php echo $__env->make('front.layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>



  <!-- Content Wrapper. Contains page content -->    
      
  <?php $__env->startSection('main_content'); ?>
  
  

<div id="banner-area" class="banner-area" style="background-image:url(<?php echo e(asset('public/front/images/banner/banner1.jpg')); ?>)">
  <div class="banner-text">
    <div class="container">
        <div class="row">
          <div class="col-lg-12">
              <div class="banner-heading">
                <h1 class="banner-title">About</h1>
              
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                      <li class="breadcrumb-item"><a href="#">Home</a></li>
                      <li class="breadcrumb-item"><a href="#">Company</a></li>
                      <li class="breadcrumb-item active" aria-current="page">About Us</li>
                    </ol>
                </nav>
              </div>
          </div><!-- Col end -->
        </div><!-- Row end -->
    </div><!-- Container end -->
  </div><!-- Banner text end -->
</div><!-- Banner area end --> 

<section id="main-container" class="main-container">
  <div class="container">
    <div class="row">
        <div class="col-lg-6">
          <h3 class="column-title">Who We Are</h3>
          <p>A leading service provider in boiler scaffolding, especially for power plants. With over 14 years of field experience, We offer expert manpower, innovative techniques, and certified safety standards. Our scaffolding solutions are designed to save time and enhance safety during critical shutdowns and maintenance operations.</p>
          <blockquote><p>We are expert in boiler scaffolding and safety compliance</p></blockquote>
          <p>Space for more description</p>

        </div><!-- Col end -->

        <div class="col-lg-6 mt-5 mt-lg-0">
          
          <div id="page-slider" class="page-slider small-bg">

              <div class="item" style="background-image:url(<?php echo e(asset('public/front/images/slider-pages/slide-page1.jpg')); ?>)">
                <div class="container">
                    <div class="box-slider-content">
                      <div class="box-slider-text">
                          <h2 class="box-slide-title">Leadership</h2>
                      </div>    
                    </div>
                </div>
              </div><!-- Item 1 end -->

              <div class="item" style="background-image:url(<?php echo e(asset('public/front/images/slider-pages/slide-page2.jpg')); ?>)">
                <div class="container">
                    <div class="box-slider-content">
                      <div class="box-slider-text">
                          <h2 class="box-slide-title">Relationships</h2>
                      </div>    
                    </div>
                </div>
              </div><!-- Item 1 end -->

              <div class="item" style="background-image:url(<?php echo e(asset('public/front/images/slider-pages/slide-page3.jpg')); ?>)">
                <div class="container">
                    <div class="box-slider-content">
                      <div class="box-slider-text">
                          <h2 class="box-slide-title">Performance</h2>
                      </div>    
                    </div>
                </div>
              </div><!-- Item 1 end -->
          </div><!-- Page slider end-->          
        

        </div><!-- Col end -->
    </div><!-- Content row end -->

  </div><!-- Container end -->
</section><!-- Main container end -->


  <?php echo $__env->make('front.sections.index.facts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

  

  <?php echo $__env->make('front.sections.about_us.ts_team', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

  <?php echo $__env->yieldSection(); ?> 
 

    
 
     
<?php $__env->startSection('footer'); ?>
 
 <?php echo $__env->make('front.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>
 



    
    <!-- Javascript Files
  ================================================== -->

  <!-- initialize jQuery Library -->
  <script src="<?php echo e(asset('public/front/plugins/jQuery/jquery.min.js')); ?>"></script>
  <!-- Bootstrap jQuery -->
  <script src="<?php echo e(asset('public/front/plugins/bootstrap/bootstrap.min.js')); ?>" defer></script>
  <!-- Slick Carousel -->
  <script src="<?php echo e(asset('public/front/plugins/slick/slick.min.js')); ?>"></script>
  <script src="<?php echo e(asset('public/front/plugins/slick/slick-animation.min.js')); ?>"></script>
  <!-- Color box -->
  <script src="<?php echo e(asset('public/front/plugins/colorbox/jquery.colorbox.js')); ?>"></script>
  <!-- shuffle -->
  <script src="<?php echo e(asset('public/front/plugins/shuffle/shuffle.min.js')); ?>" defer></script>


  <!-- Google Map API Key-->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCcABaamniA6OL5YvYSpB3pFMNrXwXnLwU" defer></script>
  <!-- Google Map Plugin-->
  <script src="<?php echo e(asset('public/front/plugins/google-map/map.js')); ?>" defer></script>

  <!-- Template custom -->
  <script src="<?php echo e(asset('public/front/js/script.js')); ?>"></script>

  </div><!-- Body inner end -->
  </body>

  </html><?php /**PATH /home/atulyascaffoldin/public_html/atulya/resources/views/front/about_us.blade.php ENDPATH**/ ?>