<!--
 // WEBSITE: https://themefisher.com
 // TWITTER: https://twitter.com/themefisher
 // FACEBOOK: https://www.facebook.com/themefisher
 // GITHUB: https://github.com/themefisher/
-->

<!-- 
THEME: Constra - Construction Html5 Template
VERSION: 1.0.0
AUTHOR: Themefisher

HOMEPAGE: https://themefisher.com/products/constra-construction-template/
DEMO: https://demo.themefisher.com/constra/
GITHUB: https://github.com/themefisher/Constra-Bootstrap-Construction-Template

WEBSITE: https://themefisher.com
TWITTER: https://twitter.com/themefisher
FACEBOOK: https://www.facebook.com/themefisher
-->

<!DOCTYPE html>
<html data-base-url="<?php echo e(url('/')); ?>" lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>

  <!-- Basic Page Needs
================================================== -->
  <meta charset="utf-8">
  <title>Atulya Scaffolding Safety and Services LLP</title>

  <!-- Mobile Specific Metas
================================================== -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="description" content="Construction Html5 Template">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
  <meta name=author content="Themefisher">
  <meta name=generator content="Themefisher Constra HTML Template v1.0">

  <!-- Favicon
================================================== -->
  <link rel="icon" type="image/png" href="<?php echo e(asset('public/front/images/favicon.png')); ?>">

  <!-- CSS
================================================== -->
  <!-- Bootstrap -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/bootstrap/bootstrap.min.css')); ?>">
  <!-- FontAwesome -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/fontawesome/css/all.min.css')); ?>">
  <!-- Animation -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/animate-css/animate.css')); ?>">
  <!-- slick Carousel -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/slick/slick.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/slick/slick-theme.css')); ?>">
  <!-- Colorbox -->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/colorbox/colorbox.css')); ?>">
  <!-- Template styles-->
  <link rel="stylesheet" href="<?php echo e(asset('public/front/css/style.css')); ?>">

</head>
<body>
  <div class="body-inner">
    
<?php $__env->startSection('topbar'); ?>
 
 <?php echo $__env->make('front.layouts.topbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>

<?php $__env->startSection('header'); ?>
 
 <?php echo $__env->make('front.layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>



  <!-- Content Wrapper. Contains page content -->    
      
  <?php $__env->startSection('main_content'); ?>
  
  

<div id="banner-area" class="banner-area" style="background-image:url(<?php echo e(asset('public/front/images/banner/banner1.jpg')); ?>)">
  <div class="banner-text">
    <div class="container">
        <div class="row">
          <div class="col-lg-12">
              <div class="banner-heading">
                <h1 class="banner-title">Gallery</h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                      <li class="breadcrumb-item"><a href="#">Home</a></li>
                      <li class="breadcrumb-item"><a href="#">Company</a></li>
                      <li class="breadcrumb-item active" aria-current="page">Gallery</li>
                    </ol>
                </nav>
              </div>
          </div><!-- Col end -->
        </div><!-- Row end -->
    </div><!-- Container end -->
  </div><!-- Banner text end -->
</div><!-- Banner area end --> 

<section id="main-container" class="main-container">
  <div class="container">
    <div class="row">
      <div class="col-12">
       

        <div class="row ">
          <?php if(!empty($galleries)): ?>
            <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="col-lg-4 col-md-6 shuffle-item m-0" data-groups="[&quot;government&quot;,&quot;healthcare&quot;]">
            <div class="project-img-container">
              <a class="gallery-popup" href="<?php echo e(create_image_path($gallery->image)); ?>">
                <img class="img-fluid" src="<?php echo e(create_image_path($gallery->image)); ?>" alt="project-image" style="width: 380px;height:304px;">
                <span class="gallery-icon"><i class="fa fa-plus"></i></span>
              </a>
              <div class="project-item-info">
                <div class="project-item-info-content">
                  <h3 class="project-item-title">
                    <a href="#"><?php echo e($gallery->title); ?></a>
                  </h3>
<!--                  <p class="project-cat"><?php echo e($gallery->title); ?></p>-->
                </div>
              </div>
            </div>
          </div><!-- shuffle item 1 end -->
           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>          
                <?php echo $__env->make('common.templates.no_data_found', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endif; ?>

          
        </div><!-- shuffle end -->
      </div>
<!--
      <div class="col-12">
        <div class="general-btn text-center">
          <a class="btn btn-primary" href="projects.html">View All Projects</a>
        </div>
      </div>
            -->

    </div><!-- Content row end -->

  </div><!-- Conatiner end -->
</section><!-- Main container end -->



  <?php echo $__env->yieldSection(); ?> 
 

    
 
     
<?php $__env->startSection('footer'); ?>
 
 <?php echo $__env->make('front.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

 <?php echo $__env->yieldSection(); ?>
 



    
    <!-- Javascript Files
  ================================================== -->

  <!-- initialize jQuery Library -->
  <script src="<?php echo e(asset('public/front/plugins/jQuery/jquery.min.js')); ?>"></script>
  <!-- Bootstrap jQuery -->
  <script src="<?php echo e(asset('public/front/plugins/bootstrap/bootstrap.min.js')); ?>" defer></script>
  <!-- Slick Carousel -->
  <script src="<?php echo e(asset('public/front/plugins/slick/slick.min.js')); ?>"></script>
  <script src="<?php echo e(asset('public/front/plugins/slick/slick-animation.min.js')); ?>"></script>
  <!-- Color box -->
  <script src="<?php echo e(asset('public/front/plugins/colorbox/jquery.colorbox.js')); ?>"></script>
  <!-- shuffle -->
  <script src="<?php echo e(asset('public/front/plugins/shuffle/shuffle.min.js')); ?>" defer></script>


  <!-- Google Map API Key-->
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCcABaamniA6OL5YvYSpB3pFMNrXwXnLwU" defer></script>
  <!-- Google Map Plugin-->
  <script src="<?php echo e(asset('public/front/plugins/google-map/map.js')); ?>" defer></script>

  <!-- Template custom -->
  <script src="<?php echo e(asset('public/front/js/script.js')); ?>"></script>

  </div><!-- Body inner end -->
  </body>

  </html><?php /**PATH /home/u967478337/domains/evsgroup.in/public_html/atulya/atulya/resources/views/front/gallery.blade.php ENDPATH**/ ?>