<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\front\auth\LoginController as FrontLoginController;
use App\Http\Controllers\LoginController;
use Illuminate\Support\Facades\Route;

//Route::get('/', function () {
//    return view('welcome');
//})->name('homepage');

Route::get('/', '\App\Http\Controllers\front\FrontController@index')->name('homepage');


Route::any('/thanks', function () {
    return view('templates.emails.owner_email_confirmation');
});
Route::any('about_us', '\App\Http\Controllers\front\FrontController@about_us')->name('about-us');
Route::any('team', '\App\Http\Controllers\front\FrontController@team')->name('team');
Route::any('testimonials', '\App\Http\Controllers\front\FrontController@testimonials')->name('testimonials');
Route::any('faq', '\App\Http\Controllers\front\FrontController@faq')->name('faq');
Route::any('pricing', '\App\Http\Controllers\front\FrontController@pricing')->name('pricing');

Route::get('contact_us', '\App\Http\Controllers\front\FrontController@contact_us')->name('contact-us');
Route::post('contact_us', '\App\Http\Controllers\front\FrontController@contact_us_submit');
Route::get('projects', '\App\Http\Controllers\front\FrontController@projects')->name('projects');
Route::get('training', '\App\Http\Controllers\front\FrontController@training')->name('training');
Route::get('downloads', '\App\Http\Controllers\front\FrontController@downloads')->name('downloads');
Route::any('download_file/{path}', '\App\Http\Controllers\front\FrontController@download_file')->where('path', '.+');

Route::get('certificate', '\App\Http\Controllers\front\FrontController@certificate')->name('certificate');
Route::post('certificate', '\App\Http\Controllers\front\FrontController@certificate_submit');

Route::any('scaffolding_product', '\App\Http\Controllers\front\FrontController@scaffolding_product')->name('scaffolding-product');
Route::any('scaffolding_services', '\App\Http\Controllers\front\FrontController@scaffolding_services')->name('scaffolding-services');
Route::any('scaffolding_material', '\App\Http\Controllers\front\FrontController@scaffolding_material')->name('scaffolding-material');
Route::any('scaffolding_design', '\App\Http\Controllers\front\FrontController@scaffolding_design')->name('scaffolding-design');

Route::any('blog', '\App\Http\Controllers\front\FrontController@blog')->name('blog');

Route::any('gallery', '\App\Http\Controllers\front\FrontController@gallery')->name('gallery');



Route::get('terms_and_conditions', '\App\Http\Controllers\front\FrontController@terms_and_conditions');
Route::get('privacy_policy', '\App\Http\Controllers\front\FrontController@privacy_policy');





Route::get('login',[FrontLoginController::class,'index'])->name('login');

Route::group(['prefix'=>'user'],function(){
    // Guest middle URL can be accessed without login
    Route::group(['middleware'=>'guest'],function(){
        Route::get('login',[LoginController::class,'index'])->name('user.login');
        Route::get('register',[LoginController::class,'register'])->name('user.register');
        Route::post('process-register',[LoginController::class,'processRegister'])->name('user.processRegister');
        Route::post('authenticate',[LoginController::class,'authenticate'])->name('user.authenticate');
    });
  // Guest middle URL can be accessed without login
      Route::group(['middleware'=>'auth'],function(){      
        Route::get('dashboard',[DashboardController::class,'index'])->name('user.dashboard');
        Route::get('logout',[LoginController::class,'logout'])->name('user.logout');
    });

});





require __DIR__.'/owner_routes.php';
   






