<?php
use Illuminate\Support\Facades\Route;




 /*
  * 
  * 
  * START OWNER ROUTES
  * 
  * 
  * 
     */

use App\Http\Controllers\owner\DashboardController as OwnerDashboardController;
use App\Http\Controllers\owner\Auth\LoginController as OwnerLoginController;






Route::get('owner/register', '\App\Http\Controllers\owner\Auth\OwnerRegisterController@index')->name('owner.register');
Route::any('owner/register_submit', '\App\Http\Controllers\owner\Auth\OwnerRegisterController@owner_registration_submit')->name('owner.registration_submit');





// Route::group(['prefix'=>'owner'],function(){
Route::name('owner.')->prefix('owner')->group(function(){
    // Guest middle URL can be accessed without login
    Route::group(['middleware'=>'owner.guest'],function(){
        Route::get('login',[OwnerLoginController::class,'index'])->name('login');
        Route::post('authenticate',[OwnerLoginController::class,'authenticate'])->name('authenticate');
        // Route::any('login', '\App\Http\Controllers\owner\Auth\OwnerLoginController@showLoginForm')->name('login_owner');
        // Route::any('login_submit', '\App\Http\Controllers\owner\Auth\OwnerLoginController@login_submit')->name('owner_login_submit');
        // Route::any('logout', '\App\Http\Controllers\owner\Auth\OwnerLoginController@logout')->name('owner_logout');
        Route::get('register', '\App\Http\Controllers\owner\Auth\OwnerRegisterController@index')->name('owner.register');
        Route::any('register_submit', '\App\Http\Controllers\owner\Auth\OwnerRegisterController@owner_registration_submit')->name('owner.registration_submit');
        // Route::get('verify-email-address', '\App\Http\Controllers\owner\Auth\OwnerLoginController@verify_email_address');
        // Route::any('send_verification_mail', '\App\Http\Controllers\owner\Auth\OwnerRegisterController@send_verification_mail');
    });

  // Guest middle URL can be accessed without login
    Route::group(['middleware'=>'owner.auth'],function(){

        Route::get('dashboard',[OwnerDashboardController::class,'index'])->name('dashboard');
        Route::get('logout',[OwnerLoginController::class,'logout'])->name('logout');

    
        /*
     * Team
     */
   
    Route::any('team/team_grid', '\App\Http\Controllers\owner\TeamController@team_grid');
    Route::resource('team', '\App\Http\Controllers\owner\TeamController');
        
         
        
     /*
     * Downloads
     */
    Route::any('training_certificate/download/{path}', '\App\Http\Controllers\owner\TrainingCertificateController@download')->where('path', '.+');
    Route::any('training_certificate/training_certificate_grid', '\App\Http\Controllers\owner\TrainingCertificateController@training_certificate_grid');
    Route::resource('training_certificate', '\App\Http\Controllers\owner\TrainingCertificateController');
        
           
     /*
     * Downloads
     */
    Route::any('document/download/{path}', '\App\Http\Controllers\owner\DocumentController@download_file')->where('path', '.+');
    Route::any('document/document_grid', '\App\Http\Controllers\owner\DocumentController@document_grid');
    Route::resource('document', '\App\Http\Controllers\owner\DocumentController');
        
           

        
     /*
     * Scaffolding Product
     */
   
    Route::any('scaffolding_product/scaffolding_product_grid', '\App\Http\Controllers\owner\ScaffoldingProductController@scaffolding_product_grid');
    Route::resource('scaffolding_product', '\App\Http\Controllers\owner\ScaffoldingProductController');
        
        
     /*
     * Scaffolding Category
     */
   
    Route::any('scaffolding_category/scaffolding_category_grid', '\App\Http\Controllers\owner\ScaffoldingCategoryController@scaffolding_category_grid');
    Route::resource('scaffolding_category', '\App\Http\Controllers\owner\ScaffoldingCategoryController');
        
        
     /*
     * Gallery
     */
   
    Route::any('gallery/gallery_grid', '\App\Http\Controllers\owner\GalleryController@gallery_grid');
    Route::resource('gallery', '\App\Http\Controllers\owner\GalleryController');
        
        
         /*
     * Project
     */
   
    Route::any('project/project_grid', '\App\Http\Controllers\owner\ProjectController@project_grid');
    Route::resource('project', '\App\Http\Controllers\owner\ProjectController');
        
 
       /*
     * Employee
     */
    Route::any('employee/employee_grid', '\App\Http\Controllers\owner\EmployeeController@employee_grid');
    Route::any('employee/profile', '\App\Http\Controllers\owner\EmployeeController@profile')->where('id', '.+');
    Route::get('employee/change_password', '\App\Http\Controllers\owner\EmployeeController@change_password');
    Route::post('employee/change_password', '\App\Http\Controllers\owner\EmployeeController@change_password_submit');
Route::any('employee/reset_password_to_default/{id}', '\App\Http\Controllers\owner\EmployeeController@reset_password_to_default')->where('id', '.+');
    Route::any('employee/employee_role_grid', '\App\Http\Controllers\owner\EmployeeController@employee_role_grid');
    Route::any('employee/sync_employee_role', '\App\Http\Controllers\owner\EmployeeController@sync_employee_role');

    Route::resource('employee', '\App\Http\Controllers\owner\EmployeeController');
  
     /*
     * RBAC
     */
    

        /*
         * Role Groups
         */
        Route::any('rbac/role_group/role_group_grid', '\App\Http\Controllers\owner\rbac\RoleGroupController@role_group_grid');
        Route::resource('rbac/role_group', '\App\Http\Controllers\owner\rbac\RoleGroupController');
        /*
         * Role
         */
//        Route::any('rbac/role/role_grid', '\App\Http\Controllers\owner\rbac\RoleController@role_grid');
//        Route::resource('rbac/role', '\App\Http\Controllers\owner\rbac\RoleController');


         /*
         * Role
         */
        Route::any('rbac/role/role_grid', '\App\Http\Controllers\owner\rbac\RoleController@role_grid');
        Route::resource('rbac/role', '\App\Http\Controllers\owner\rbac\RoleController');
        
        /*
         * Permission
         */
        Route::any('rbac/permission/permission_grid', '\App\Http\Controllers\owner\rbac\PermissionController@permission_grid');
        Route::resource('rbac/permission', '\App\Http\Controllers\owner\rbac\PermissionController');

        /*
         * Module Role Permission
         */
        Route::any('rbac/module_role_permission/manage_permission_grid', '\App\Http\Controllers\owner\rbac\ModuleRolePermissionController@manage_permission_grid');

        Route::any('rbac/module_role_permission/sync_module_role_permission', '\App\Http\Controllers\owner\rbac\ModuleRolePermissionController@sync_module_role_permission');
        Route::resource('rbac/module_role_permission', '\App\Http\Controllers\owner\rbac\ModuleRolePermissionController');
        
        
    
    
    
/*
     * SiteSettings
     */
    Route::any('site_setting/site_setting_grid', '\App\Http\Controllers\owner\SiteSettingController@site_setting_grid');
    Route::resource('site_setting', '\App\Http\Controllers\owner\SiteSettingController');

/*
     * Dashboard
     */
    //  Route::any('dashboard/set_school_id/{school_id}', '\App\Http\Controllers\owner\DashboardController@set_school_id')->where('school_id', '.+');
    //  Route::any('dashboard/select_school', '\App\Http\Controllers\owner\DashboardController@select_school');
     Route::any('dashboard', '\App\Http\Controllers\owner\DashboardController@index');


 
    });

});




   /*
  * 
  * 
  * END OWNER ROUTES
  * 
  * 
  * 
     */