



@extends('owner.layouts.layout')

@section('main_content')

@include('common.templates.content_header',['module'=>'Product','breadcrumb'=>'Product','breadcrumb_active'=>'Edit'])

<!--begin::App Content-->
<div class="app-content"> <!--begin::Container-->
    <div class="container-fluid"> <!--begin::Row-->
        <div class="row">
            <div class="col-12"> 
                <!-- Default box -->
                <div class="card card-primary card-outline p-0">
                    <div class="card-header">
                        <!--                                    <h3 class="card-title">Title</h3>-->

                        @include('common.templates.back_button')

                        <div class="card-tools">
                          @include('common.templates.add_new_button',['url'=>'owner/scaffolding_product/create'])

                        </div>
                    </div>

                    <div class="card-body table-responsive">

    <!-- form start -->
        <form class="ajax-form-submit" id="my_form" name="my_form" method="post" action="{{ route('owner.scaffolding_product.update', $row->id) }}" data-redirect-link="{{url('owner/scaffolding_product')}}" enctype='multipart/form-data' onsubmit="tinyMCE.triggerSave();">
             {{ method_field('PATCH') }}
                {{ csrf_field() }}

      


                        <div class="row">

                            <div class="col-md-12 col-12">



                                

                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Name</label>
                                    <input type="text" name='name' id="name" class="form-control"  placeholder="Name" data-parsley-required='true' data-parsley-minlength='2'  data-parsley-maxlength='100' value="{{$row->name}}" >
                                </div>
                                <!-- /.form-group -->            

                                
                                     <div class="form-group mb-3">
                                        <label class="form-label fw-bold" for="profile_image">Image</label>
                                        <div class="input-group mb-3">
                                            <input name="scaffolding_product_image" type="file" id="scaffolding_product_image" class="form-control" data-parsley-fileextension="jpg,jpeg" data-parsley-fileextension-message="File should be .jpg or .jpeg only" data-parsley-maxfilesize="2048" data-parsley-maxfilesize-message="The file must be samller than 2MB" data-title="Product Image" title="Product image"> 
                                            <label class="input-group-text" for="scaffolding_product_image">(.jpg,.jpeg)</label> </div>
                                    </div>

                                    <!-- /.form-group -->

                                 <div class="form-group mb-3">
                                     <label class="form-label fw-bold">Current Image</label>
                                    <div class="form-control" style="border:0px">
                                          <span class="start"><img src="{{create_image_path($row->image)}}" class="img elevation-2" alt="User Image" height='150' width="150"></span>
           
                                    </div>
                                
                                </div>
                                <!-- /.form-group -->

                              
                                
                                
                                  <div class="form-group mb-3">
                                   <label class="form-label fw-bold">Status</label>
                                    <select name="status" id="status" class="form-control form-select" data-parsley-required='true'>
                                        <option value="">Select</option>            
                                        @foreach(config('constants.GENERAL_STATUS') as $key=>$status)
                                        <option value='{{$key}}' @if($key == $row->status) selected @endif>{{$status}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <!-- /.form-group -->


                         

                            </div>
                            <!-- /.col-md-12 col-12 -->


                        </div>
                        <!-- /.row -->
     
          
            
                          <div class="row mt-4 mb-4">
                                <div class="col-md-12 col-12">
                                    <div class="box-footer float-end">                
                                        <button type="submit" class="btn btn-primary pull-right"><i class="fas fa-save"></i> Save</button>
                                    </div>
                                    <!-- /.box-footer -->
                                </div>
                                <!-- /.col-md-12 col-12 -->
                            </div>
                            <!-- /.row -->

             
        </form>
        <script>$("#my_form").parsley();</script>



                    </div> 
                    <!-- /.card-body -->
<!--                    <div class="card-footer">Footer</div> -->
                    <!-- /.card-footer-->
                </div> 
                <!-- /.card -->
            </div>
        </div> 
        <!--end::Row-->
    </div>
</div>
<!--end::App Content-->




@endsection



