@extends('front.layouts.layout')

@section('main_content')



   <main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">Terms and Conditions</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{ url('/') }}">Home</a></li>
            <li class="current">Terms and Conditions</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Contact Section -->
    <section id="contact" class="contact section">

        
        
       @include('common.templates.ajax_div')
 
      
      <div style="text-align: center; padding-left: 20px; padding-right: 20px;">
            @include('common.templates.flash_message_all')
    </div> 
      
       
 <div class="container my-5">
        <div class="text-center mb-4">
            <h1>Terms and Conditions</h1>
            <p class="text-muted">Effective Date: January 20, 2025</p>
        </div>
        <div class="card shadow-sm">
            <div class="card-body">
                <h2 class="card-title">1. Introduction</h2>
                <p class="card-text">Welcome to the official website of {{ config('constants.APP_NAME') }}. This website is designed to provide information about the school, its policies, academic programs, and services. By accessing this website, you agree to comply with and be bound by the following terms and conditions. If you do not agree to these terms, please discontinue your use of the website.</p>

                <h2 class="card-title mt-4">2. Purpose of Data Collection</h2>
                <p class="card-text">The website collects and processes student data to enhance academic performance, facilitate communication between teachers, parents, and students, and provide a better educational experience. Data collected includes academic records, attendance, extracurricular participation, and behavioral insights. All data collected is used exclusively for educational and administrative purposes.</p>

                <h2 class="card-title mt-4">3. Data Privacy and Security</h2>
                <p class="card-text">At {{ config('constants.APP_NAME') }}, we are committed to protecting your privacy. Student data is securely stored using advanced encryption methods and is accessed only by authorized personnel. The school complies with all relevant data protection regulations, ensuring the confidentiality and integrity of the information.</p>
                <p class="card-text">No personal data will be shared with third parties without prior consent, except where required by law or to safeguard the well-being of students.</p>

                <h2 class="card-title mt-4">4. User Responsibilities</h2>
                <p class="card-text">Users are expected to use the website responsibly and ethically. This includes providing accurate information during registration and refraining from activities that may disrupt the functionality of the website. Unauthorized access, data breaches, or misuse of the information available on the website will be subject to disciplinary and legal action.</p>

                <h2 class="card-title mt-4">5. Content Ownership</h2>
                <p class="card-text">All content, including but not limited to text, images, graphics, and software, is the intellectual property of {{ config('constants.APP_NAME') }} and is protected under copyright laws. Duplication, distribution, or modification of any content without prior written permission is strictly prohibited.</p>

                <h2 class="card-title mt-4">6. Website Usage Guidelines</h2>
                <p class="card-text">The website is intended for educational and informational purposes only. Users must refrain from using the website for unauthorized commercial activities, distributing harmful software, or engaging in any activity that violates local, state, or national laws.</p>

                <h2 class="card-title mt-4">7. External Links</h2>
                <p class="card-text">The website may contain links to external sites for additional resources and information. {{ config('constants.APP_NAME') }} is not responsible for the content, policies, or practices of these external websites. Users are advised to review the terms and privacy policies of any external sites they visit.</p>

                <h2 class="card-title mt-4">8. Amendments to Terms</h2>
                <p class="card-text">{{ config('constants.APP_NAME') }} reserves the right to modify these terms and conditions at any time. Updates will be published on this page, and users are encouraged to review the terms periodically. Continued use of the website after changes indicates acceptance of the revised terms.</p>

                <h2 class="card-title mt-4">9. Limitation of Liability</h2>
                <p class="card-text">While every effort is made to ensure the accuracy of information on the website, {{ config('constants.APP_NAME') }} does not guarantee the completeness or reliability of the content. The school will not be held liable for any direct, indirect, or consequential damages arising from the use of the website.</p>

                <h2 class="card-title mt-4">10. Contact Information</h2>
                <p class="card-text">For any questions, concerns, or feedback regarding these terms and conditions or the website, please contact {{ config('constants.APP_NAME') }} at <a href="mailto:info@schoolify.com">info@schoolify.com</a> or call +91-7017 828 662 during working hours.</p>
            </div>
        </div>
    </div>

    </section><!-- /Contact Section -->

  </main>
@endsection