@extends('front.layouts.layout')

@section('main_content')



   <main class="main">

    <!-- Page Title -->
    <div class="page-title light-background">
      <div class="container d-lg-flex justify-content-between align-items-center">
        <h1 class="mb-2 mb-lg-0">Terms and Conditions</h1>
        <nav class="breadcrumbs">
          <ol>
            <li><a href="{{ url('/') }}">Home</a></li>
            <li class="current">Terms and Conditions</li>
          </ol>
        </nav>
      </div>
    </div><!-- End Page Title -->

    <!-- Contact Section -->
    <section id="contact" class="contact section">

        
        
       @include('common.templates.ajax_div')
 
      
      <div style="text-align: center; padding-left: 20px; padding-right: 20px;">
            @include('common.templates.flash_message_all')
    </div> 
      
       
   <div class="container my-5">
        <div class="text-center mb-4">
            <h1>Privacy Policy</h1>
            <p class="text-muted">Effective Date: January 20, 2025</p>
        </div>
        <div class="card shadow-sm">
            <div class="card-body">
                <h2 class="card-title">1. Introduction</h2>
                <p class="card-text">This Privacy Policy outlines how Schoolify collects, uses, and protects the personal information of its website users. By accessing or using our website, you consent to the practices described in this policy.</p>

                <h2 class="card-title mt-4">2. Information We Collect</h2>
                <p class="card-text">We may collect the following types of information:
                    <ul>
                        <li><strong>Personal Information:</strong> Name, email address, phone number, and other contact details provided during registration or communication.</li>
                        <li><strong>Academic Information:</strong> Test scores, attendance, and other data related to academic performance.</li>
                        <li><strong>Technical Information:</strong> IP addresses, browser type, device information, and usage data collected through cookies and similar technologies.</li>
                    </ul>
                </p>

                <h2 class="card-title mt-4">3. How We Use Your Information</h2>
                <p class="card-text">The collected information is used for the following purposes:
                    <ul>
                        <li>To improve academic performance and provide personalized educational support.</li>
                        <li>To enhance the functionality and user experience of our website.</li>
                        <li>To communicate important updates, announcements, and event information.</li>
                        <li>To comply with legal and regulatory requirements.</li>
                    </ul>
                </p>

                <h2 class="card-title mt-4">4. Data Sharing and Disclosure</h2>
                <p class="card-text">We do not sell or rent your personal information to third parties. However, we may share your information with:
                    <ul>
                        <li><strong>Authorized Personnel:</strong> Teachers, administrators, and staff for educational purposes.</li>
                        <li><strong>Service Providers:</strong> Third-party vendors who assist with website functionality and data analysis, subject to confidentiality agreements.</li>
                        <li><strong>Legal Authorities:</strong> When required by law or to protect the rights and safety of our students and staff.</li>
                    </ul>
                </p>

                <h2 class="card-title mt-4">5. Data Security</h2>
                <p class="card-text">We employ advanced security measures to safeguard your personal information. These include encryption, secure servers, and restricted access protocols. While we strive to protect your data, no system is completely secure, and we cannot guarantee absolute security.</p>

                <h2 class="card-title mt-4">6. Cookies and Tracking Technologies</h2>
                <p class="card-text">Our website uses cookies and similar technologies to enhance user experience and analyze website traffic. You can manage your cookie preferences through your browser settings. Disabling cookies may impact certain website functionalities.</p>

                <h2 class="card-title mt-4">7. Your Rights</h2>
                <p class="card-text">As a user, you have the right to:
                    <ul>
                        <li>Access the personal information we hold about you.</li>
                        <li>Request corrections to inaccurate or incomplete data.</li>
                        <li>Request deletion of your personal information, subject to legal and contractual obligations.</li>
                        <li>Opt out of receiving non-essential communications.</li>
                    </ul>
                </p>

                <h2 class="card-title mt-4">8. Changes to This Policy</h2>
                <p class="card-text">We may update this Privacy Policy from time to time. Any changes will be posted on this page, and the updated policy will take effect immediately upon posting. Users are encouraged to review this policy periodically.</p>

                <h2 class="card-title mt-4">9. Contact Us</h2>
                <p class="card-text">If you have any questions, concerns, or requests regarding this Privacy Policy, please contact us at <a href="mailto:info@sschoolify.com">info@schoolify.com</a> or call +91-7017 868 626.</p>
            </div>
        </div>
    </div>

    </section><!-- /Contact Section -->

  </main>
@endsection