/*
 * 
 * 
 * Following are the functions to export grid data to various formats 
 * 
 * Different libraris are used which is inside ultimate-export folder
 * 
 * this file must be included after including all libraries to the page
 * 
 * <script src="{{asset('public/admin/adminlte_3.2.0/plugins/ultimate-export/libs/FileSaver/FileSaver.min.js')}}"></script>
<script src="{{asset('public/admin/adminlte_3.2.0/plugins/ultimate-export/libs/js-xlsx/xlsx.core.min.js')}}"></script>
<script src="{{asset('public/admin/adminlte_3.2.0/plugins/ultimate-export/libs/jsPDF/polyfills.umd.min.js')}}"></script>
<script src="{{asset('public/admin/adminlte_3.2.0/plugins/ultimate-export/libs/jsPDF/jspdf.umd.min.js')}}"></script>
<script src="{{asset('public/admin/adminlte_3.2.0/plugins/ultimate-export/libs/html2canvas/html2canvas.min.js')}}"></script>
<script src="{{asset('public/admin/adminlte_3.2.0/plugins/ultimate-export/tableExport.min.js')}}"></script>
</script>
 * 
 * <style id="table_style" type="text/css">
    
    @media print {

      .table
    {
        font-family: Arial;
        font-size: 10pt;
    }
    .grid_table
    {
        border: 1px solid #ccc;
        border-collapse: collapse;
    }
    .grid_table th
    {
        background-color: #F7F7F7;
        color: #333;
        font-weight: bold;
    }
    .grid_table th, .grid_table td
    {
        padding: 5px;
        border: 1px solid #ccc;
    }
  
}
    .grid_table tbody
    {
        font-family: Arial;
        font-size: 10pt;
    }
    .table_grid_print
    {
        border: 1px solid #ccc;
        border-collapse: collapse;
    }
    .table_grid_print th
    {
        background-color: #F7F7F7;
        color: #333;
        font-weight: bold;
    }
    .table_grid_print th, .table_grid_print td
    {
        padding: 5px;
        border: 1px solid #ccc;
    }
</style>
 * 
 * 
 * 
 * 
 * https://www.jqueryscript.net/table/ultimate-export.html
 * 
 */


  function print_grid_table(grid_div_id='myTable') {
      

      
      $("#" + grid_div_id + " .grid_data"+" .grid_actions").css("display", "none");
      
        var printWindow = window.open('', '', 'height=600,width=800');
        //$("#p").css("background-color", "yellow");
        printWindow.document.write('<html><head><title>Table Contents</title>');
 
        //Print the Table CSS.
        var table_style = document.getElementById("table_style").innerHTML;
        printWindow.document.write('<style type = "text/css">');
        printWindow.document.write(table_style);
        printWindow.document.write('</style>');
        printWindow.document.write('</head>');
 
 
 
 
        //Print the DIV contents i.e. the HTML Table.
        printWindow.document.write('<body class="table_grid_body">');
//        printWindow.document.write('<table class="table table-bordered table-stripped grid_table" id="myTable">');
          var parent = document.querySelector('#'+grid_div_id);
    //console.log(parent); // 
    var table  = parent.querySelector('.grid_data');
        var divContents = table.innerHTML;
        printWindow.document.write(divContents);
          $("#" + grid_div_id + " .grid_data"+" .grid_actions").css("display", "block");
//        printWindow.document.write('</table');
        printWindow.document.write('</body>');
 
        printWindow.document.write('</html>');
       
        printWindow.document.close();
        printWindow.print();
        
      //   $("#" + grid_div_id + " .grid_data"+" .grid_actions").css("display", "show");
    }
    
   
function copy_grid_table(grid_div_id="grid_data") {    
   //const type = "text/html";
    var parent = document.querySelector('#'+grid_div_id);
    //console.log(parent); // 
    var table  = parent.querySelector('.grid_data');
  let text = table.innerHTML;
 // console.log(text); // 
  navigator.clipboard.writeText(text);
 alert('Copied');
    }
    
function export_to_csv(result_div="grid_data") { 
      var column_to_ignore = getColumnIndexesByClass(result_div,'grid_actions');
          $("#" + result_div + " .grid_data").tableExport({
               ignoreColumn: [column_to_ignore],
          fileName: 'CSV-Export-'+new Date().toISOString(), 
       
        });
    }
function export_to_pdf(result_div="grid_data") {
    
      var column_to_ignore = getColumnIndexesByClass(result_div,'grid_actions');
          $("#" + result_div + " .grid_data").tableExport({
            type:'pdf',
             ignoreColumn: [column_to_ignore],
            fileName: 'PDF-Export-'+new Date().toISOString(),
            jspdf: {
                // jsPDF options
              }
        });
    }
function export_to_excel(result_div="grid_data") {  
    var column_to_ignore = getColumnIndexesByClass(result_div,'grid_actions');
   // alert(column_to_ignore);
             $("#" + result_div + " .grid_data").tableExport({
             type:'excel',
             ignoreColumn: [column_to_ignore],
             fileName: 'Excel-Export-'+new Date().toISOString(),
        });
    }
    
 function getColumnIndexesByClass(result_div="grid_data",class_name='grid_actions') {
    var column_index =  $("#" + result_div + " .grid_data"+" ." + class_name).index();
    // alert(column_index)
//  return $("#" + result_div + " .grid_data"+" ." + class_name).map(function() {
//    return $(this).index() ; // add one because nth-child is not zero based
//  }).get();
return column_index
}   