
var LOCAL_MODE = typeof LOCAL_MODE !== 'undefined' ? LOCAL_MODE : false;

if (!document.getElementById('ajax-div')) {
    $('body').append('<div id="ajax-div"></div>');
}

// Extract form attributes
function form_check_required_attributes(form) {
    const $form = $(form);
    return {
        output_div: $form.data('output-div') || "ajax-div",
        formid: $form.attr('id') || '',
        method: $form.attr('method') || '',
        actionurl: $form.attr('action') || '',
        redirect_link: $form.data('redirect-link'),
        page_reload: $form.data('page-reload') === true,
        show_after_form: $form.data('show-after-form') === true,
        show_in_modal: $form.data('show-in-modal') === false,
        show_progress_bar: $form.data('show-progress-bar') === true,
        disable_output_div: $form.data('disable-output-div') === true,
        hide_on_complete: $form.data('hide-on-complete') !== false,
        disable_form_reset: $form.data('disable-form-reset') === true
    };
}

function show_output_in_modal(content = "", title = "Submitting...") {
    const id = 'ajax_output_modal';
    const modalSelector = `#${id}`;

    if (!document.getElementById(id)) {
        $("body").append(`
            <div class="modal fade" id="${id}" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">${title}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body" style="max-height:70vh; overflow-y:auto; word-break:break-word;"></div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
        `);
    }

    $(`${modalSelector} .modal-title`).html(title);
    $(`${modalSelector} .modal-body`).html(content);
    $(modalSelector).modal('show');
}

function ajax_form_load(attr) {
//alert(attr.output_div);
    // Get position from form attribute
const $form = $(`#${attr.formid}`);
// const positionClass = $form.data('position') || 'top-right';
 const progressColor = $form.data('progress-bar-color') || 'bg-primary';
// $(`#${attr.output_div}`).removeClass('top-right top-left bottom-right bottom-left').addClass(positionClass);

if(attr.output_div == 'ajax-div'){
let position = $form.data('position') || 'top-middle';
$(`#${attr.output_div}`).removeClass('top-right top-left bottom-right bottom-left top-middle bottom-middle').addClass("ajax-div " + position);
//$("#" + req_attrib.output_div).removeClass().addClass("ajax-div " + position);
}
// Ensure the ajax-div has the correct position class
// const $ajaxDiv = $(`#${attr.output_div}`);
// $ajaxDiv.removeClass('top-right top-left bottom-right bottom-left').addClass(positionClass);

  const loaderHTML = `
    <div id="ajax-output-wrapper">
        ${attr.show_progress_bar ? `
        <div class="ajax-progress-container">
            <div class="progress">
                <div class="progress-bar ${progressColor} myprogress" role="progressbar" style="width: 0%;">0%</div>
            </div>
        </div>` : ''}
        <div id="ajax-output"></div>
    </div>
    <div id="ajax-loader">
        <div class="spinner-border text-primary" role="status"></div>
        <span class="ms-2">Submitting, please wait...</span>
    </div>
`;


    if (attr.show_in_modal) {
        show_output_in_modal(loaderHTML, 'Submitting...');
    } else if (attr.output_div && !attr.disable_output_div) {
        $(`#${attr.output_div}`).html(loaderHTML).show();
    } else if (attr.show_after_form) {
        $(`#${attr.formid}`).after(loaderHTML);
    } else {
        $("#ajax-div").html(loaderHTML).show();
    }

    $(".myprogress").css("width", "0%");
    $("#ajax-loader").show();
}

function ajax_form_success(attr, response) {
    const content = response.message;

    if (response.status === 'success' || response.status === true) {
        if (attr.show_in_modal) {
            show_output_in_modal(content, "Success");
        } else if (attr.output_div && !attr.disable_output_div) {
            $(`#${attr.output_div} #ajax-output`).html(content);
        } else if (attr.show_after_form) {
            $(`#${attr.formid}`).after(content);
        } else {
            $("#ajax-div #ajax-output").html(content);
        }

        if (attr.page_reload) {
            setTimeout(() => location.reload(), 2000);
        } else if (attr.redirect_link) {
            setTimeout(() => location.href = attr.redirect_link, 2000);
        } else if (!attr.disable_form_reset) {
            $(`#${attr.formid}`)[0].reset();
        }

    } else {
        if (attr.show_in_modal) {
            show_output_in_modal(content, "Error");
        } else if (attr.output_div) {
            $(`#${attr.output_div} #ajax-output`).html(content);
        } else if (attr.show_after_form) {
            $(`#${attr.formid}`).after(content);
        } else {
            $("#ajax-div #ajax-output").html(content);
        }
    }

    $("#ajax-loader").hide();
}

function ajax_form_complete(attr) {
    if (attr.hide_on_complete) {
        if (!attr.show_in_modal) {
            let selector = attr.output_div ? `#${attr.output_div}` : "#ajax-div";
           $(selector).fadeTo(5000,1).slideUp(500, function () {
                $(this).hide().css('opacity', 1).html('');
        });
        }
    }
}

function ajax_form_error(attr, xhr, status, error) {
    if (LOCAL_MODE) {
        show_output_in_modal(xhr.responseText, `${status} - ${error}`);
    } else {
        alert(`${status} - Error: ${error}`);
    }
}

$(document).on('submit', 'form.ajax-form-submit', function (e) {
    e.preventDefault();
    const form = this;
    const attr = form_check_required_attributes(form);

    if (!attr.formid || !attr.method || !attr.actionurl) {
        alert("Form must have id, method, and action.");
        return false;
    }

    if (attr.disable_output_div && !attr.show_after_form && !attr.show_in_modal) {
        alert("No output method defined. Cannot submit.");
        return false;
    }

    const formData = new FormData(form);

    $.ajax({
        type: attr.method,
        url: attr.actionurl,
        async: true,
        cache: false,
        data: formData,
        dataType: 'json',
        beforeSend: function () {
            ajax_form_load(attr);
            $('.myprogress').css('width', '0');
        },
        xhr: function () {
            const xhr = new window.XMLHttpRequest();
            xhr.upload.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    const percent = parseInt((evt.loaded / evt.total) * 100);
                    $('.myprogress').text(`${percent}%`).css('width', `${percent}%`);
                }
            });
            return xhr;
        },
        contentType: false,
        processData: false,
        success: function (response) {
            ajax_form_success(attr, response);
        },
        error: function (xhr, status, error) {
            ajax_form_error(attr, xhr, status, error);
        },
        complete: function () {
            ajax_form_complete(attr);
        }
    });

    return false;
});

$(document).on('click', '.btn-close', function () {
   // alert('to close');
    $('.ajax-progress-container').html('');
    const $box = $(this).parent('.ajax-div');
  //  console.log($box);
   $box.html('').hide();
    // $box.fadeOut(300, function () {
       
    // });
});



