<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // 
      

        $middleware->alias([
        

            'guest'=>\App\Http\Middleware\UserRedirect::class,
            'auth'=> \App\Http\Middleware\UserAuthenticate::class,
           
            'superadmin.guest'=>\App\Http\Middleware\SuperadminRedirect::class,
            'superadmin.auth'=> \App\Http\Middleware\SuperadminAuthenticate::class,
           
            'owner.guest'=>\App\Http\Middleware\OwnerRedirect::class,
            'owner.auth'=> \App\Http\Middleware\OwnerAuthenticate::class,
           
            'employee.guest'=>\App\Http\Middleware\EmployeeRedirect::class,
            'employee.auth'=> \App\Http\Middleware\EmployeeAuthenticate::class,
           
            'parent.guest'=>\App\Http\Middleware\ParentRedirect::class,
            'parent.auth'=> \App\Http\Middleware\ParentAuthenticate::class,
           
            'student.guest'=>\App\Http\Middleware\StudentRedirect::class,
            'student.auth'=> \App\Http\Middleware\StudentAuthenticate::class,
           
            
            'Helper' => App\Helpers\Helper::class,
            'Hashing' => App\Helpers\Hashing::class,
            'flash_messages' => App\Helpers\flash_messages::class,

             // Session  enable for constructor method call done by me SVV and Disabled from  protected $middlewareGroups[] in this KERNEL
         \Illuminate\Session\Middleware\StartSession::class,
         \Illuminate\View\Middleware\ShareErrorsFromSession::class,
        
        ]);

        $middleware->redirectTo(
            guests:'/account/login',
            users:'/account/dashboard',
        );

  
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
