<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;



use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Cache;
use App\Models\rbac\ModuleRolePermission;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\Auth;



class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot() :void
    {
        $this->registerPolicies();

        /*

        This RBAC is created by me eith the help of my previous RBAC and chat GPT

        */

      $mrps = Cache::rememberForever('module_role_permissions', function () {
            return ModuleRolePermission::with(['module', 'role', 'permission'])->get();
        });

        foreach ($mrps as $mrp) {
            $slug = $mrp->module->m_code . '|' . $mrp->permission->p_code;

            Gate::define($slug, function ($user) use ($mrp) {
                if (!$user || !method_exists($user, 'user_roles')) {
                    return false;
                }

                $roles = $user->user_roles->pluck('role_id')->toArray();
                return in_array($mrp->role->id, $roles);
            });
        }

        $guards = config('auth.guards');

        $guard_array = [];
        foreach ($guards as $guardName => $guardConfig) {
            array_push($guard_array, $guardName);
        }
        Blade::if('hasPermission', function ($slug) {
            foreach ($guard_array as $guard) {
                if (Auth::guard($guard)->check()) {
                    return Gate::forUser(Auth::guard($guard)->user())->allows($slug);
                }
            }
            return false;
        });
        
    }
}
