<?php

namespace App\Models\rbac;

use Illuminate\Database\Eloquent\Model;

class Role extends Model {

    protected $table = 'rbac_roles';
    protected $fillable = [
        'name', 'r_code', 'description', 'status', 'level',
    ];
//    protected $casts = [
//        'status' => 'bool',
//        'level' => 'int',
//    ];
    public $timestamps = false;

  public function role_group() {
        return $this->hasOne('App\Models\rbac\RoleGroup', 'id','rg_id');
    }          
  



   public function school() {
        $school = $this->hasOne(\App\Models\School::Class,'id','school_id');
        return $school;
    }
     public function parent()
 {
 return $this->belongsTo(\App\Models\rbac\Role::Class, 'parent_id');
 }
public function children()
 {
 return $this->hasMany(\App\Models\rbac\Role::Class, 'parent_id');
 }  


}

// end class
