<?php
    
namespace App\Http\Controllers\owner\rbac;

use Illuminate\Session\Store;
use App\Http\Controllers\owner\OwnerBaseController ;

use Illuminate\Http\Request;


use App\Models\rbac\Role;
use App\Models\SchoolRole;
use App\Models\rbac\RoleGroup;
use App\Models\SchoolOwner;
use App\Models\School;

use DB;
use Hash;
use Response;
use Auth;
use App\Helpers\flash_messages ;

use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

use View;


  
class RoleController extends OwnerBaseController
{
    

      public function __construct(Store $session){
        parent::__construct($session);
      
    }

    public function roles(Request $request) {
        //dd($request->all());
        $owner = Role::findorfail($request->owner_id);
        //dd($owner);
        $owner->syncRoles($request->roles);
        return redirect('owner/role')->with('success', 'Roles added successfully!');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request) {

        return view('owner.rbac.role.index');
    }

      public function role_grid(Request $req) {  
          $owner_id = Auth::guard('owner')->user()->id;
          
          $school_id = $this->get_current_school_id();
        
        
        $school_role_ids = SchoolRole::where('school_id','=',$school_id)->pluck('role_id')->toArray();
        
        $roles = Role::where('school_id','=',$school_id)
                        ->orWhere('school_id','=',0)                       
                        ->where('status','=',1)
                        ->get();      
        $scr_array = $roles->toArray();
        $currentid = Auth::guard('owner')->user()->role_id;
        $role_down = $this->role_down($scr_array,$currentid);            
        $role_down_ids = $this->role_down_ids($role_down);
       
        $search_term = $req['search_term'];
        $limit = !empty($req['limit']) ? $req['limit'] : config('constants.LIMIT_GRID_PER_PAGE');        
        $search_coloumns = ['r_name','id','r_code'];
            if(!empty($search_term)){
                $rows = Role::where(function($q) use($search_coloumns, $search_term) {
                        foreach ($search_coloumns as $field)
                           $q->orWhere($field, 'like', "%{$search_term}%");
                })
                        ->where('school_id','=',$school_id)
                        ->orWhere('school_id','=',0)
                        ->where('id', '>=', 1)
                        ->where('status','=',1)
                        ->paginate($limit);
            }else{
                $rows = Role::where('school_id','=',$school_id)
                            ->orWhere('school_id','=',0)
                            ->where('belongs_to','=','school')
                            ->where('status','=',1)
                            ->paginate($limit); 
             }
    
        return view('owner.rbac.role.role_grid',['result_data'=>$rows,'school_role_ids'=>$school_role_ids,'role_down_ids'=>$role_down_ids]);
    }  
    

     public function role_group_down($all_role_group_array, $currentid, $parentfound = false, $role_groups = array()){
    foreach($all_role_group_array as $row){
        if((!$parentfound && $row['id'] == $currentid) || $row['parent_id'] == $currentid  ){
            $rowdata = array();
            foreach($row as $k => $v)
                $rowdata[$k] = $v;
            $role_groups[] = $rowdata;
            if($row['parent_id'] == $currentid )
                $role_groups = array_merge($role_groups, $this->role_group_down($all_role_group_array, $row['id'], true));
        }
    }
    
    return $role_groups;
}
    

    
   public function role_group_down_ids($data_from_role_group_down = array()){
       if(!empty($data_from_role_group_down)){
           $role_group_down_ids = array();
            foreach($data_from_role_group_down as $row){
                array_push($role_group_down_ids,$row['id']);
            }
       }
    return $role_group_down_ids;
}
   
    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
        
         $owner_id = Auth::guard('owner')->user()->id;
           $role_groups = RoleGroup::all();
         
             $owner_school_ids = SchoolOwner::where('owner_id','=',$owner_id)->pluck('school_id')->toArray();   
             
             $owner_schools = School::whereIn('id',$owner_school_ids)->get();
          
          
           $user_role_group = RoleGroup::where('rg_code', Auth::guard('owner')->user()->role_group)->first();
      
            $scr_array = $role_groups->toArray();
            $currentid = $user_role_group->id;
            $current_parent = $user_role_group->parent_id;

           // $role_group_down = $this->role_group_up($scr_array,$current_parent);
            
            $role_group_down = $this->role_group_down($scr_array,$currentid);
           // dd($role_group_down);
            $role_group_down_ids = $this->role_group_down_ids($role_group_down);
        return view('owner.rbac.role.create',[
            'owner_schools'=>$owner_schools,
            'role_groups'=>$role_group_down,
            
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        $v = Validator::make($data, [
            'name' => ['required', 'string', 'min:2','max:100'],
           // 'code' => ['required', 'string', 'min:2', 'max:128'],
            'status' => ['required', 'integer'],
            'school' => ['required', 'integer'],
            'role_group' => ['required', 'integer'],
         
        ]);


        //dd($v->errors());
       if ($v->fails()) {
            if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
        
        }
        
        $school_id = $request->school;
        $r_code = slugify_underscore($data['name']);
          $check_role = $this->check_unique_role($r_code,$id=0,$school_id);    
        if(!empty($check_role->r_code)){
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_role['status']];
            
            
              if($request->ajax()){
             flash_messages::add_message('e', 'This role already exists and in '.$state.' State. Kindly contact change role code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This role already exists and in '.$state.' State. Kindly contact change role code');
            
      
            
           // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }     
        
       
      
        
        
        $role = new Role();
        $role->r_name = $request->name;
        $role->r_code = slugify_underscore($request->name);
        $role->is_default = 0;
        $role->belongs_to = 'school';
        $role->school_id = $request->school;      
        $role->description = $request->description;
        $role->status = $request->status;
    
        $role->save();

       
        if ($role->id) {           
             if($request->ajax()){
             flash_messages::add_message('s', 'Role added successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect('owner/employee')->with('success','Role added successfully!');           
        } else {
            
              if($request->ajax()){
             flash_messages::add_message('e', 'Unable to add Role. Please try again!');
            return flash_messages::display_message(true);
            }   
           return redirect()->back()->with('error','Unable to add Role. Please try again!');       
        }


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id) {
    
         $row = Role::findOrFail($id);

   
        return view('owner.role.show', [
            'row' => $row, 
       //     'Role' => $Role, 
            
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id) {
      
        $row = Role::findOrFail($id);

        return view('owner.rbac.role.edit', [
            'row' => $row, 
            
           
        ]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id) {

        $data = $request->all();
        //dd($data);
        unset($data['_method']);
        unset($data['_token']);

        /*$owner = Role::find($id);*/

       $v = Validator::make($data, [
            'name' => ['required', 'string', 'min:2','max:100'],
           // 'code' => ['required', 'string', 'min:2','max:100'],
            'status' => ['required', 'integer'],
              
        ]);


        //dd($v->errors());
        if ($v->fails()) {
             if($request->ajax()){
               flash_messages::add_message('e', $v->errors()->all());
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error', $v->errors()->all());
             
         //   return redirect(url('owner/owner/create'))->withErrors($v)->withInput($data);
        }

        
              $r_code = slugify_underscore($data['code']);
          $check_role = $this->check_unique_role($r_code,$id);    
        if(!empty($check_role->r_code)){
            $status = config('constants.GENERAL_STATUS');
            $state = $status[$check_role['status']];
            
                if($request->ajax()){
             flash_messages::add_message('e', 'This role already exists and in '.$state.' State. Kindly contact change role code');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('error','This role already exists and in '.$state.' State. Kindly contact change role code');
            
           // return redirect()->back()->withErrors('This email already taken and in '.$state.' State. Kindly contact Administrator')->withInput($data);  
        }     
        
        
        $check = Role::findorfail($id);
        //$owner->assignRole($request->role);



           $save =  Role::where('id', $id)->update([
            'r_name'  => $data['name'],
           // 'r_code'  => slugify_underscore($data['code']),
            'description'  => $data['description'],
            'status'  => $data['status'],
            
        ]);

            if($request->ajax()){
             flash_messages::add_message('s', 'Updated successfully!');
            return flash_messages::display_message(true);
            }            
           return redirect()->back()->with('success','Updated successfully!');
       // return redirect()->back()->with('success', 'Data updated successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id) {
        $row = Role::where('id', $id)->first();
        if($row->role == 'owner') {
            return redirect('owner/role')->with('error', 'Admin owners can not be deleted');
        }
        $row->status = '2';
        $row->delete();
        return redirect('owner/role')->with('success', 'Role deleted successfully!');
    }


    public function check_unique_role($r_code,$id=0,$school_id=0) {
        $row = Role::where('r_code', $r_code)->where('school_id',"=" ,$school_id)->where('id',"!=" ,$id)->first();
        return $row;
    }
    
    
 
}